<?php
$page_title = "About , MaColX";
include __DIR__ . "/includes/header.php";
?>

<style>
  .mx-about-hero{
    position: relative;
    border-radius: 1.75rem;
    padding: 2.5rem 2rem;
    background:
      radial-gradient(circle at 0 0, #22c55e 0, rgba(34,197,94,0) 45%),
      radial-gradient(circle at 100% 0, #0ea5e9 0, rgba(14,165,233,0) 50%),
      radial-gradient(circle at 0 100%, #a855f7 0, rgba(168,85,247,0) 55%),
      linear-gradient(135deg, #020617, #020617);
    color: #f9fafb;
    box-shadow: 0 24px 60px rgba(15,23,42,0.7);
    overflow: hidden;
  }
  .mx-about-hero::before{
    content: "";
    position: absolute;
    inset: -30%;
    background:
      radial-gradient(120% 120% at 10% 0, rgba(248,250,252,0.18) 0, transparent 50%),
      radial-gradient(140% 140% at 100% 60%, rgba(248,250,252,0.12) 0, transparent 55%);
    mix-blend-mode: screen;
    opacity: .9;
    pointer-events: none;
  }
  .mx-about-inner{
    position: relative;
    z-index: 2;
  }
  .mx-about-photo-wrap{
    max-width: 320px;
    margin-left: auto;
  }
  .mx-pill{
    display: inline-flex;
    align-items: center;
    gap: .4rem;
    padding: .35rem .9rem;
    border-radius: 999px;
    background: rgba(15,23,42,0.85);
    border: 1px solid rgba(148,163,184,0.55);
    font-size: .78rem;
    color: #e5e7eb;
    backdrop-filter: blur(14px);
  }
  .mx-pill-dot{
    width: .45rem;
    height: .45rem;
    border-radius: 999px;
    background: #22c55e;
    box-shadow: 0 0 0 .18rem rgba(34,197,94,0.4);
  }
  .mx-about-tag{
    font-size: .78rem;
    padding: .25rem .75rem;
    border-radius: 999px;
    border: 1px solid rgba(148,163,184,0.4);
    color: #e5e7eb;
    background: rgba(15,23,42,0.4);
  }
  .mx-about-subtitle{
    max-width: 34rem;
  }
  .mx-about-grid-card{
    border-radius: 1.2rem;
    padding: 1rem 1.1rem;
    background: #ffffff;
    box-shadow: 0 12px 30px rgba(15,23,42,0.06);
  }
  .mx-about-grid-card small{
    font-size: .8rem;
  }
  .mx-about-list li{
    margin-bottom: .55rem;
  }
  .mx-about-metric-card{
    border-radius: 1.2rem;
    padding: 1rem 1.1rem;
    background: #f8fafc;
    border: 1px solid rgba(148,163,184,0.35);
    text-align: center;
  }
  .mx-about-metric-label{
    font-size: .78rem;
    text-transform: uppercase;
    letter-spacing: .16em;
    color: #6b7280;
  }
  .mx-about-metric-number{
    font-size: 1.7rem;
    font-weight: 600;
    color: #0f172a;
  }
  .mx-about-metric-caption{
    font-size: .8rem;
    color: #6b7280;
  }
  @media (max-width: 767.98px){
    .mx-about-hero{
      padding: 1.9rem 1.4rem;
      border-radius: 1.3rem;
    }
    .mx-about-photo-wrap{
      max-width: 240px;
      margin-right: auto;
    }
  }
</style>

<!-- HERO , JOSHUA AND MACOLX -->
<section class="section">
  <div class="container">
    <div class="mx-about-hero">
      <div class="mx-about-inner">
        <div class="row align-items-center gy-4">
          <div class="col-lg-7">
            <div class="mb-2">
              <span class="mx-pill">
                <span class="mx-pill-dot"></span>
                <span>Founder and Lead, MaColX</span> 
              </span>
            </div>

            <h1 class="h1 mb-2">
              Digital health, data, and delivery for real programmes
            </h1>

            <p class="small mb-2 text-light">
              Joshua Marius Acolatse, Accra Ghana
            </p>

            <p class="mx-about-subtitle small mb-3 text-light">
              I work where information systems meet programme delivery.  
              At Ghana Health Service and through MaColX, I help teams move from scattered data and spreadsheets,
              to dependable platforms, analytics, and tools that support everyday decisions for public health.
            </p>

            <div class="d-flex flex-wrap gap-2 mb-3">
              
              <span class="mx-about-tag">
                Senior IT Manager, Head - Software Unit, Ghana Health Service
              </span>
            </div>

            <div class="d-flex flex-wrap gap-2">
              <a
                href="<?= $base ?>/assets/Joshua_Acolatse_CV.pdf"
                class="btn btn-mx btn-sm">
                Download CV
              </a>
              <a
                href="<?= $base ?>/projects.php"
                class="btn btn-ghost btn-sm">
                View selected work
              </a>
              <a
                href="<?= $base ?>/contact.php"
                class="btn btn-outline-light btn-sm">
                Contact
              </a>
            </div>
          </div>

          <div class="col-lg-5">
            <div class="mx-about-photo-wrap mx-glass p-2 rounded-4 bg-white bg-opacity-90">
              <img
                src="<?= $base ?>/assets/img/headshot.jpg"
                alt="Joshua Acolatse"
                class="img-fluid img-rounded img-shadow w-100 object-fit-cover">
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- ABOUT JOSHUA, SHORT BIO -->
<section class="section">
  <div class="container">
    <div class="row g-4 align-items-start">
      <div class="col-lg-7">
        <h2 class="h3 mb-2 section-title">
          Who I am and how I work
        </h2>
        <p class="small text-muted mb-3">
          My daily work sits between ministry teams, software engineers, and programme managers.
          I help define what information a programme really needs,
          then design, build, and operationalise systems that provide that information reliably.
        </p>
        <p class="small text-muted mb-3">
          Over the past few years I have led or supported national dashboards, community reporting tools,
          and data pipelines for Ghana Health Service, the Ministry of Health, and partners.
          This includes work on community health reporting, COVID 19 analytics,
          facility assessments, and digital tools for frontline teams.
        </p>
        <p class="small text-muted mb-0">
          I care about systems that are simple to use, respectful of data governance,
          and realistic for the teams that will live with them after the consultants and developers leave.
        </p>
      </div>

      <div class="col-lg-5">
        <div class="mx-about-grid-card">
          <h3 class="h6 text-uppercase ls-wide mb-2">
            Focus areas
          </h3>
          <ul class="small text-muted mb-0 mx-about-list">
            <li>Design and delivery of digital health platforms for routine reporting and decision support.</li>
            <li>Data engineering and analytics, including forecasting and risk scoring for public health questions.</li>
            <li>Bringing data from national systems into clear dashboards for managers and programme leads.</li>
            <li>Mentoring local teams in software practice, analytics, and documentation so that work continues locally.</li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- MACOLX IN BRIEF -->
<section class="section section-alt">
  <div class="container">
    <div class="row g-4 align-items-center mb-3">
      <div class="col-lg-7">
        <h2 class="h3 mb-2 section-title">
          MaColX in brief
        </h2>
        <p class="small text-muted mb-0">
          MaColX is a focused practice that supports ministries, implementers, and partners
          to design and run digital health systems that are reliable, evidence led, and realistic for the field.
        </p>
      </div>
      <div class="col-lg-5 text-lg-end">
        <span class="badge rounded-pill text-bg-light text-muted small">
          Evidence based, no patient identifiers, implementation first
        </span>
      </div>
    </div>

    <div class="row g-4">
      <div class="col-md-4 d-flex">
        <div class="mx-glass mx-card-hover flex-fill h-100 p-3">
          <div class="d-flex align-items-center gap-2 mb-2">
            <div class="mx-service-icon">
              <i class="bi bi-diagram-3"></i>
            </div>
            <div class="small text-muted text-uppercase ls-wide">
              Digital health platforms
            </div>
          </div>
          <p class="small text-muted mb-0">
            Support to design, build, and strengthen platforms that follow national architecture, data ownership,
            and integration plans, from community reporting to national level dashboards.
          </p>
        </div>
      </div>

      <div class="col-md-4 d-flex">
        <div class="mx-glass mx-card-hover flex-fill h-100 p-3">
          <div class="d-flex align-items-center gap-2 mb-2">
            <div class="mx-service-icon">
              <i class="bi bi-activity"></i>
            </div>
            <div class="small text-muted text-uppercase ls-wide">
              Data and analytics
            </div>
          </div>
          <p class="small text-muted mb-0">
            Forecasts, risk scores, and dashboards that use transparent methods,
            with clear documentation so that programme teams can explain what the numbers mean.
          </p>
        </div>
      </div>

      <div class="col-md-4 d-flex">
        <div class="mx-glass mx-card-hover flex-fill h-100 p-3">
          <div class="d-flex align-items-center gap-2 mb-2">
            <div class="mx-service-icon">
              <i class="bi bi-gear-wide-connected"></i>
            </div>
            <div class="small text-muted text-uppercase ls-wide">
              Implementation and delivery
            </div>
          </div>
          <p class="small text-muted mb-0">
            Practical support from idea to production, including user testing, documentation, and training,
            so that systems remain usable and maintainable after go live.
          </p>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- HOW MACOLX WORKS WITH TEAMS -->
<section class="section">
  <div class="container">
    <div class="row g-4 align-items-start">
      <div class="col-lg-6">
        <h2 class="h4 mb-2 section-title">
          How projects usually run
        </h2>
        <p class="small text-muted mb-3">
          Every setting is different, but there are patterns that work well with ministries and partners.
          The aim is to move from concept to a clear, documented solution that fits existing processes.
        </p>
        <ul class="small text-muted mb-0 mx-about-list">
          <li>Start with programme questions and reporting lines, not with tools.</li>
          <li>Co design with Ghana Health Service and ministry teams so workflows reflect how supervision and reporting really work.</li>
          <li>Use modern open technology stacks, for example DHIS2, PostgreSQL, secure web frameworks, Python and R for analytics.</li>
          <li>Plan for handover from day one, with documentation, training materials, and local ownership of code and data flows.</li>
          <li>Use synthetic or aggregated data in demonstrations, never real patient records or names.</li>
        </ul>
      </div>

      <div class="col-lg-6">
        <div class="mx-glass p-3 p-md-4 h-100">
          <h3 class="h6 text-uppercase ls-wide mb-2">
            Skills and tools
          </h3>
          <p class="small text-muted mb-3">
            A mix of software engineering, analytics, and public health experience.
          </p>
          <div class="row small text-muted">
            <div class="col-sm-6 mb-2">
              <strong>Engineering</strong><br>
              PHP, Java, Python, JavaScript, REST APIs, integration work with national systems.
            </div>
            <div class="col-sm-6 mb-2">
              <strong>Data and analytics</strong><br>
              SQL, Python, R, data modeling, forecasting, Power BI, dashboard design.
            </div>
            <div class="col-sm-6 mb-2">
              <strong>Health systems</strong><br>
              Routine data, facility assessments, community and primary care reporting, work with DHIS2.
            </div>
            <div class="col-sm-6 mb-0">
              <strong>Ways of working</strong><br>
              Agile delivery, documentation, mentorship, and long term support options where needed.
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- COMPLIANCE STRIP -->
    <div class="mx-glass p-3 p-md-4 my-5 small text-muted text-center">
      <strong>Compliance and standards.</strong>
      Work aligns with national data policies and global digital health guidance,
      including ICD 10 or ICD 11 coding, HL7 FHIR concepts, privacy principles similar to HIPAA,
      and the World Health Organization digital health guidelines.
      Demonstrations never use patient identifiable information.
    </div>
  </div>
</section>

<!-- SELECTED IMPACT -->
<section class="section section-metrics">
  <div class="container">
    <div class="row align-items-center gy-4">
      <div class="col-lg-5">
        <h2 class="h4 mb-2 section-title">
          Selected impact
        </h2>
        <p class="small text-muted mb-3">
          A brief view of work across national dashboards, community tools, and analytics projects.
        </p>
        <ul class="small text-muted mb-0 mx-about-list">
          <li>COVID 19 dashboards and planning tools for national and regional teams.</li>
          <li>Community home visit reporting with alerts for risk and referrals within CHPS zones.</li>
          <li>Data flows and analytics for facility assessments such as HHFA.</li>
          <li>Support and mentorship for young developers and analysts working inside the health sector.</li>
        </ul>
      </div>

      <div class="col-lg-7">
        <div class="row g-3">
          <div class="col-6 col-md-3">
            <div class="mx-about-metric-card h-100">
              <div class="mx-about-metric-label">Health programmes</div>
              <div class="mx-about-metric-number">20+</div>
              <div class="mx-about-metric-caption">
                National and sub national efforts supported.
              </div>
            </div>
          </div>
          <div class="col-6 col-md-3">
            <div class="mx-about-metric-card h-100">
              <div class="mx-about-metric-label">Facilities</div>
              <div class="mx-about-metric-number">150+</div>
              <div class="mx-about-metric-caption">
                Sites using digital reporting or dashboards.
              </div>
            </div>
          </div>
          <div class="col-6 col-md-3">
            <div class="mx-about-metric-card h-100">
              <div class="mx-about-metric-label">Pipelines</div>
              <div class="mx-about-metric-number">10+</div>
              <div class="mx-about-metric-caption">
                Automated data and analytics workflows.
              </div>
            </div>
          </div>
          <div class="col-6 col-md-3">
            <div class="mx-about-metric-card h-100">
              <div class="mx-about-metric-label">Uptime target</div>
              <div class="mx-about-metric-number">99.7%</div>
              <div class="mx-about-metric-caption">
                Availability goal for core platforms.
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- FINAL CALL TO ACTION -->
<section class="section">
  <div class="container">
    <div class="cta-box p-4 p-md-5 rounded-4 shadow-sm text-center mx-glass">
      <h2 class="h3 mb-2 section-title">
        Ready to talk about a project or collaboration
      </h2>
      <p class="small text-muted mb-4">
        Share a short note on your context and what you want to improve.
        I will respond with a practical view of what is possible, and the first concrete next steps.
      </p>
      <button
        class="btn btn-mx btn-lg"
        data-bs-toggle="modal"
        data-bs-target="#leadModal">
        Start a conversation
      </button>
    </div>
  </div>
</section>

<?php include __DIR__ . "/includes/footer.php"; ?>
