<?php
// admin/_healthcheck.php
declare(strict_types=1);

// Always use the single root config
require_once __DIR__ . '/../config.php';

/** @var PDO|null $pdo */
$pdo = db();

header('Content-Type: text/plain; charset=utf-8');

echo "=== MaColX Healthcheck ===\n";
echo "Config file loaded: " . realpath(__DIR__ . '/../config.php') . "\n";
echo "PHP constants -> DB_HOST=" . (defined('DB_HOST') ? DB_HOST : '(undefined)') .
     " DB_PORT=" . (defined('DB_PORT') ? DB_PORT : '(undefined)') .
     " DB_NAME=" . (defined('DB_NAME') ? DB_NAME : '(undefined)') .
     " DB_USER=" . (defined('DB_USER') ? DB_USER : '(undefined)') . "\n";

if (!$pdo) {
  echo "PDO: not connected\n";
  exit(0);
}

echo "PDO: connected\n";

// Show who MySQL thinks you are
try {
  $currentUser = $pdo->query("SELECT CURRENT_USER()")->fetchColumn();
  $userFunc    = $pdo->query("SELECT USER()")->fetchColumn();
  echo "MySQL CURRENT_USER(): " . $currentUser . "\n";
  echo "MySQL USER():         " . $userFunc . "\n";
} catch (Throwable $e) {
  echo "Error reading CURRENT_USER(): " . $e->getMessage() . "\n";
}

// List tables
try {
  $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
  echo "Tables in " . DB_NAME . ": " . (empty($tables) ? "(none)" : implode(', ', $tables)) . "\n";
} catch (Throwable $e) {
  echo "Error listing tables: " . $e->getMessage() . "\n";
}

// Optional app-specific checks
try {
  $countPosts = $pdo->query("SELECT COUNT(*) FROM posts")->fetchColumn();
  echo "posts.count: " . (int)$countPosts . "\n";
} catch (Throwable $e) {
  echo "posts.check error: " . $e->getMessage() . "\n";
}

// Show grants for the logged-in MySQL account (useful if INSERTs fail)
try {
  $grants = $pdo->query("SHOW GRANTS")->fetchAll(PDO::FETCH_COLUMN);
  echo "Grants:\n";
  foreach ($grants as $g) echo "  - $g\n";
} catch (Throwable $e) {
  echo "SHOW GRANTS error: " . $e->getMessage() . "\n";
}

echo "=== End ===\n";
