<?php
// admin/_auth.php
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}

// set your admin password here, or via an environment variable ADMIN_PASS
$expected = getenv('ADMIN_PASS') ?: 'MaColXAdmin123';

if (isset($_GET['logout'])) {
  $_SESSION['is_admin'] = false;
  header('Location: '.$_SERVER['PHP_SELF']);
  exit;
}

$auth = !empty($_SESSION['is_admin']);

if (!$auth && $_SERVER['REQUEST_METHOD'] === 'POST') {
  $pass = trim($_POST['password'] ?? '');
  if (hash_equals($expected, $pass)) {
    $_SESSION['is_admin'] = true;
    header('Location: '.$_SERVER['PHP_SELF']);
    exit;
  } else {
    $error = 'Wrong password';
  }
}

if (!$auth) {
  // Minimal inline page to prompt for the password
  ?><!doctype html>
  <html lang="en"><head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin login, MaColX</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  </head>
  <body class="bg-light">
    <div class="container py-5">
      <div class="row justify-content-center">
        <div class="col-md-5">
          <div class="card shadow-sm border-0">
            <div class="card-body">
              <h1 class="h4 mb-3">Admin login</h1>
              <?php if (!empty($error)): ?>
                <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
              <?php endif; ?>
              <form method="post" class="d-grid gap-3">
                <div>
                  <label class="form-label">Password</label>
                  <input type="password" name="password" class="form-control" required>
                </div>
                <button class="btn btn-primary">Enter</button>
              </form>
              <div class="mt-3">
                <small class="text-muted">Tip, set ADMIN_PASS in your server environment for better security.</small>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </body></html><?php
  exit;
}
