<?php
// admin/leads.php

// optional debug
// ini_set('display_errors',1); ini_set('display_startup_errors',1); error_reporting(E_ALL);

if (session_status() === PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../config.php';

$pdo = db();

/* simple admin gate, same style as new_post.php */
$expected_pass = getenv('ADMIN_PASS') ?: 'MaColXAdmin123';
if (isset($_GET['logout'])) { $_SESSION['is_admin'] = false; header("Location: " . $_SERVER['PHP_SELF']); exit; }

if (empty($_SESSION['is_admin'])) {
  if ($_SERVER['REQUEST_METHOD']==='POST' && !empty($_POST['password'])) {
    $entered = trim($_POST['password']);
    if (hash_equals($expected_pass, $entered)) { $_SESSION['is_admin']=true; header("Location: " . $_SERVER['PHP_SELF']); exit; }
    else { $error = "Wrong password."; }
  }
  ?>
  <!doctype html><html lang="en"><head>
    <meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin Login , MaColX</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  </head><body class="bg-light">
  <div class="container py-5"><div class="row justify-content-center"><div class="col-md-5">
    <div class="card shadow-sm border-0"><div class="card-body">
      <h1 class="h4 mb-3">Admin Login</h1>
      <?php if (!empty($error)): ?><div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div><?php endif; ?>
      <form method="post" class="d-grid gap-3">
        <div><label class="form-label">Password</label><input type="password" name="password" class="form-control" required></div>
        <button class="btn btn-primary">Enter</button>
      </form>
      <div class="mt-3 text-muted small">Default password, <code>MaColXAdmin123</code>. Set <code>ADMIN_PASS</code> to change.</div>
    </div></div>
  </div></div>
  </body></html>
  <?php
  exit;
}

/* csrf */
if (empty($_SESSION['csrf_token'])) { $_SESSION['csrf_token'] = bin2hex(random_bytes(32)); }
$csrf = $_SESSION['csrf_token'];

/* actions: export csv, delete one */
$action = $_GET['action'] ?? '';

/* filters */
$q          = trim($_GET['q'] ?? '');
$date_from  = trim($_GET['date_from'] ?? '');
$date_to    = trim($_GET['date_to'] ?? '');
$page       = max(1, (int)($_GET['page'] ?? 1));
$per_page   = min(50, max(5, (int)($_GET['per_page'] ?? 12)));

$where = [];
$params = [];

if ($q !== '') {
  $where[] = "(full_name LIKE ? OR email LIKE ? OR phone LIKE ? OR company LIKE ? OR service LIKE ?)";
  for ($i=0;$i<5;$i++) { $params[] = "%{$q}%"; }
}
if ($date_from !== '' && preg_match('/^\d{4}-\d{2}-\d{2}$/',$date_from)) {
  $where[] = "DATE(created_at) >= ?";
  $params[] = $date_from;
}
if ($date_to !== '' && preg_match('/^\d{4}-\d{2}-\d{2}$/',$date_to)) {
  $where[] = "DATE(created_at) <= ?";
  $params[] = $date_to;
}
$where_sql = $where ? ('WHERE ' . implode(' AND ', $where)) : '';

/* export csv */
if ($action === 'export') {
  header('Content-Type: text/csv; charset=utf-8');
  header('Content-Disposition: attachment; filename=leads_' . date('Ymd_His') . '.csv');
  $out = fopen('php://output', 'w');
  fputcsv($out, ['ID','Full Name','Email','Phone','Company','Service','Message','Created']);
  $stmt = $pdo->prepare("SELECT id, full_name, email, phone, company, service, message, created_at FROM leads $where_sql ORDER BY id DESC");
  $stmt->execute($params);
  while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
    fputcsv($out, $row);
  }
  fclose($out);
  exit;
}

/* delete one */
$flash_msg = ''; $flash_type='info';
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['delete_id'])) {
  if (!hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'] ?? '')) {
    $flash_msg = 'Security check failed.'; $flash_type='danger';
  } else {
    $del_id = (int)$_POST['delete_id'];
    try {
      $stmt = $pdo->prepare("DELETE FROM leads WHERE id=?");
      $stmt->execute([$del_id]);
      $flash_msg = 'Lead removed.'; $flash_type='success';
    } catch (Exception $e) {
      $flash_msg = 'Could not remove lead.'; $flash_type='danger';
    }
  }
}

/* pagination */
$count_stmt = $pdo->prepare("SELECT COUNT(*) FROM leads $where_sql");
$count_stmt->execute($params);
$total = (int)$count_stmt->fetchColumn();
$pages = max(1, (int)ceil($total / $per_page));
$offset = ($page - 1) * $per_page;

/* fetch page */
$sql = "SELECT id, full_name, email, phone, company, service, message, created_at
        FROM leads
        $where_sql
        ORDER BY id DESC
        LIMIT $per_page OFFSET $offset";
$list_stmt = $pdo->prepare($sql);
$list_stmt->execute($params);
$rows = $list_stmt->fetchAll();

/* include header */
$page_title = "Admin , Leads";
include __DIR__ . "/../includes/header.php";
?>

<section class="section">
  <div class="container">
    <div class="d-flex justify-content-between align-items-center mb-3">
      <h1 class="h3 mb-0">Leads</h1>
      <div class="d-flex gap-2">
        <a class="btn btn-outline-secondary" href="<?php echo $base; ?>/admin/new_post.php">New post</a>
        <a class="btn btn-outline-danger" href="<?php echo $_SERVER['PHP_SELF']; ?>?logout=1">Logout</a>
      </div>
    </div>

    <?php if ($flash_msg): ?>
      <div class="alert alert-<?php echo htmlspecialchars($flash_type); ?> shadow-sm"><?php echo htmlspecialchars($flash_msg); ?></div>
    <?php endif; ?>

    <!-- Filters -->
    <form method="get" class="row g-2 mb-3">
      <div class="col-md-4">
        <input type="text" name="q" value="<?php echo htmlspecialchars($q); ?>" class="form-control" placeholder="Search name, email, phone, company, service">
      </div>
      <div class="col-md-3">
        <input type="date" name="date_from" value="<?php echo htmlspecialchars($date_from); ?>" class="form-control" placeholder="From">
      </div>
      <div class="col-md-3">
        <input type="date" name="date_to" value="<?php echo htmlspecialchars($date_to); ?>" class="form-control" placeholder="To">
      </div>
      <div class="col-md-2 d-flex gap-2">
        <button class="btn btn-primary flex-fill">Filter</button>
        <a class="btn btn-outline-secondary" href="<?php echo $_SERVER['PHP_SELF']; ?>">Reset</a>
      </div>
      <div class="col-12 mt-2">
        <a class="btn btn-sm btn-outline-success" href="<?php echo $_SERVER['PHP_SELF']; ?>?action=export<?php
          echo ($q!=='' ? '&q='.urlencode($q) : '');
          echo ($date_from!=='' ? '&date_from='.urlencode($date_from) : '');
          echo ($date_to!=='' ? '&date_to='.urlencode($date_to) : '');
        ?>">Export CSV</a>
      </div>
    </form>

    <!-- Table -->
    <div class="table-responsive">
      <table class="table align-middle">
        <thead class="table-light">
          <tr>
            <th>ID</th>
            <th>Full name</th>
            <th>Email</th>
            <th>Phone</th>
            <th>Company</th>
            <th>Service</th>
            <th>Created</th>
            <th style="width: 80px;">Action</th>
          </tr>
        </thead>
        <tbody>
        <?php if (!$rows): ?>
          <tr><td colspan="8"><div class="alert alert-info m-2">No leads found for the current filter.</div></td></tr>
        <?php else: foreach ($rows as $r): ?>
          <tr>
            <td><?php echo (int)$r['id']; ?></td>
            <td>
              <a href="#" class="text-decoration-none" data-bs-toggle="modal" data-bs-target="#leadViewModal"
                 data-lead='<?php echo json_encode($r, JSON_HEX_APOS | JSON_HEX_AMP | JSON_HEX_QUOT); ?>'>
                 <?php echo htmlspecialchars($r['full_name']); ?>
              </a>
            </td>
            <td><a href="mailto:<?php echo htmlspecialchars($r['email']); ?>"><?php echo htmlspecialchars($r['email']); ?></a></td>
            <td><?php echo htmlspecialchars($r['phone']); ?></td>
            <td><?php echo htmlspecialchars($r['company']); ?></td>
            <td><?php echo htmlspecialchars($r['service']); ?></td>
            <td><small class="text-muted"><?php echo htmlspecialchars($r['created_at']); ?></small></td>
            <td>
              <form method="post" onsubmit="return confirm('Remove this lead?');">
                <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf); ?>">
                <input type="hidden" name="delete_id" value="<?php echo (int)$r['id']; ?>">
                <button class="btn btn-sm btn-outline-danger">Delete</button>
              </form>
            </td>
          </tr>
        <?php endforeach; endif; ?>
        </tbody>
      </table>
    </div>

    <!-- Pagination -->
    <?php if ($pages > 1): ?>
      <nav>
        <ul class="pagination">
          <?php
          // helper to keep filters in links
          function build_link($p) {
            $qs = $_GET; $qs['page'] = $p;
            return htmlspecialchars($_SERVER['PHP_SELF'] . '?' . http_build_query($qs));
          }
          ?>
          <li class="page-item <?php echo $page<=1?'disabled':''; ?>">
            <a class="page-link" href="<?php echo build_link(max(1,$page-1)); ?>">Prev</a>
          </li>
          <?php
          // show up to 7 pages centered
          $start = max(1, $page-3);
          $end   = min($pages, $page+3);
          for ($p=$start; $p<=$end; $p++):
          ?>
            <li class="page-item <?php echo $p===$page?'active':''; ?>">
              <a class="page-link" href="<?php echo build_link($p); ?>"><?php echo $p; ?></a>
            </li>
          <?php endfor; ?>
          <li class="page-item <?php echo $page>=$pages?'disabled':''; ?>">
            <a class="page-link" href="<?php echo build_link(min($pages,$page+1)); ?>">Next</a>
          </li>
        </ul>
      </nav>
    <?php endif; ?>

  </div>
</section>

<!-- View Modal -->
<div class="modal fade" id="leadViewModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content rounded-4">
      <div class="modal-header">
        <h5 class="modal-title">Lead details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <dl class="row mb-0">
          <dt class="col-sm-4">Full name</dt><dd class="col-sm-8" id="lv_name"></dd>
          <dt class="col-sm-4">Email</dt><dd class="col-sm-8" id="lv_email"></dd>
          <dt class="col-sm-4">Phone</dt><dd class="col-sm-8" id="lv_phone"></dd>
          <dt class="col-sm-4">Company</dt><dd class="col-sm-8" id="lv_company"></dd>
          <dt class="col-sm-4">Service</dt><dd class="col-sm-8" id="lv_service"></dd>
          <dt class="col-sm-4">Message</dt><dd class="col-sm-8" id="lv_message" style="white-space:pre-wrap"></dd>
          <dt class="col-sm-4">Created</dt><dd class="col-sm-8" id="lv_created"></dd>
        </dl>
      </div>
    </div>
  </div>
</div>

<script>
// hydrate modal with row data
const leadViewModal = document.getElementById('leadViewModal');
leadViewModal.addEventListener('show.bs.modal', function (event) {
  const link = event.relatedTarget;
  const data = JSON.parse(link.getAttribute('data-lead') || '{}');

  const set = (id, val) => document.getElementById(id).textContent = val || '';
  set('lv_name',    data.full_name);
  set('lv_email',   data.email);
  set('lv_phone',   data.phone);
  set('lv_company', data.company);
  set('lv_service', data.service);
  set('lv_message', data.message);
  set('lv_created', data.created_at);
});
</script>

<?php include __DIR__ . "/../includes/footer.php"; ?>
