<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
$expected_pass = getenv('ADMIN_PASS') ?: 'MaColXAdmin123';
if (isset($_GET['logout'])) { $_SESSION['is_admin'] = false; header("Location: ".$_SERVER['PHP_SELF']); exit; }
if (empty($_SESSION['is_admin'])) {
  if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['password']) && hash_equals($expected_pass, trim($_POST['password']))) {
    $_SESSION['is_admin'] = true; header("Location: ".$_SERVER['PHP_SELF']); exit;
  } ?>
  <!doctype html><html lang="en"><head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Admin Login, MaColX</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  </head><body class="bg-light">
  <div class="container py-5"><div class="row justify-content-center"><div class="col-md-5">
    <div class="card shadow-sm border-0"><div class="card-body">
      <h1 class="h4 mb-3">Admin Login</h1>
      <form method="post" class="d-grid gap-3">
        <div><label class="form-label">Password</label><input type="password" name="password" class="form-control" required></div>
        <button class="btn btn-primary">Enter</button>
      </form>
      <div class="mt-3 text-muted small">Tip, set ADMIN_PASS in your server environment for better security.</div>
    </div></div>
  </div></div></div>
  </body></html><?php exit; }
if (empty($_SESSION['csrf_token'])) { $_SESSION['csrf_token'] = bin2hex(random_bytes(32)); }
$page_title = "Admin, Media"; include __DIR__ . "/../includes/header.php";

$uploadDir = dirname(__DIR__) . "/assets/uploads";
$uploadUrlBase = rtrim(dirname(dirname($_SERVER['SCRIPT_NAME'])), '/\\'); if ($uploadUrlBase === '/' || $uploadUrlBase === '\\') { $uploadUrlBase = ''; }
$uploadUrlBase .= "/assets/uploads";

$files = [];
if (is_dir($uploadDir)) {
  foreach (scandir($uploadDir) as $f) {
    if ($f === '.' || $f === '..') continue;
    $path = $uploadDir . "/" . $f; if (!is_file($path)) continue;
    $ext = strtolower(pathinfo($f, PATHINFO_EXTENSION)); if (!in_array($ext, ['jpg','jpeg','png','gif','webp'])) continue;
    $files[] = ['name'=>$f, 'size'=>filesize($path), 'mtime'=>filemtime($path), 'url'=>$uploadUrlBase . "/" . rawurlencode($f)];
  }
  usort($files, fn($a,$b)=> $b['mtime'] <=> $a['mtime']);
}
?>
<section class="section"><div class="container">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h3 mb-0">Media Library</h1>
    <div class="d-flex gap-2">
      <a href="<?php echo $base; ?>/admin/new_post.php" class="btn btn-outline-secondary">New post</a>
      <a href="<?php echo $base; ?>/blog.php" class="btn btn-outline-secondary">View blog</a>
      <a href="<?php echo $_SERVER['PHP_SELF']; ?>?logout=1" class="btn btn-outline-danger">Logout</a>
    </div>
  </div>
  <?php if (empty($files)): ?>
    <div class="alert alert-info shadow-sm">No images yet. Use the editor Image button on New post to upload.</div>
  <?php else: ?>
    <div class="row g-3">
      <?php foreach ($files as $file): ?>
      <div class="col-6 col-md-4 col-lg-3">
        <div class="card h-100 shadow-sm border-0">
          <img src="<?php echo htmlspecialchars($file['url']); ?>" class="card-img-top" alt="media">
          <div class="card-body">
            <div class="small text-truncate" title="<?php echo htmlspecialchars($file['name']); ?>"><?php echo htmlspecialchars($file['name']); ?></div>
            <div class="text-muted small mb-2"><?php echo round($file['size']/1024); ?> KB, <?php echo date('Y-m-d H:i', $file['mtime']); ?></div>
            <div class="d-grid gap-2">
              <button type="button" class="btn btn-sm btn-outline-primary" onclick="copyToClipboard('<?php echo htmlspecialchars($file['url']); ?>')">Copy URL</button>
              <form method="post" action="<?php echo $base; ?>/admin/remove_image.php" onsubmit="return confirm('Delete this image, you cannot undo');">
                <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($_SESSION['csrf_token']); ?>">
                <input type="hidden" name="name" value="<?php echo htmlspecialchars($file['name']); ?>">
                <button class="btn btn-sm btn-outline-danger">Delete</button>
              </form>
            </div>
          </div>
        </div>
      </div>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>
</div></section>
<script>
function copyToClipboard(text){ navigator.clipboard.writeText(text).then(function(){ alert('Copied, '+text); }, function(){ prompt('Copy URL', text); }); }
</script>
<?php include __DIR__ . "/../includes/footer.php"; ?>
