<?php
// optional debug
// ini_set('display_errors',1); ini_set('display_startup_errors',1); error_reporting(E_ALL);

if (session_status() === PHP_SESSION_NONE) { session_start(); }

/* SIMPLE ADMIN PASSWORD GATE */
$expected_pass = getenv('ADMIN_PASS') ?: 'MaColXAdmin123';

if (isset($_GET['logout'])) {
  $_SESSION['is_admin'] = false;
  header("Location: " . $_SERVER['PHP_SELF']);
  exit;
}

if (empty($_SESSION['is_admin'])) {
  if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['password'])) {
    $entered = trim($_POST['password']);
    if (hash_equals($expected_pass, $entered)) {
      $_SESSION['is_admin'] = true;
      header("Location: " . $_SERVER['PHP_SELF']);
      exit;
    } else {
      $error = "Wrong password.";
    }
  } ?>
  <!doctype html>
  <html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin Login , MaColX</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  </head>
  <body class="bg-light">
  <div class="container py-5">
    <div class="row justify-content-center">
      <div class="col-md-5">
        <div class="card shadow-sm border-0">
          <div class="card-body">
            <h1 class="h4 mb-3">Admin Login</h1>
            <?php if (!empty($error)): ?>
              <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
            <?php endif; ?>
            <form method="post" class="d-grid gap-3">
              <div>
                <label class="form-label">Password</label>
                <input type="password" name="password" class="form-control" required>
              </div>
              <button class="btn btn-primary">Enter</button>
            </form>
            <div class="mt-3 text-muted small">
              Default password, <code>MaColXAdmin123</code>.
              Set <code>ADMIN_PASS</code> to change.
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  </body>
  </html>
  <?php
  exit;
}

/* CSRF + DB */
if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

$page_title = "Admin , Posts";
include __DIR__ . "/../includes/header.php";

$pdo = db();
$msg = "";
$msg_type = "info";

/* form state */
$title = $category = $excerpt = $content = "";
$cover_url = "";
$editing_post_id = 0;

/* HANDLE POST ACTIONS (DELETE OR SAVE) */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $pdo) {

  $token_ok = isset($_POST['csrf_token']) && hash_equals($_SESSION['csrf_token'], $_POST['csrf_token']);

  if (!$token_ok) {
    $msg = "Security check failed, please reload and try again.";
    $msg_type = "danger";
  } else {

    /* DELETE ACTION */
    if (isset($_POST['action']) && $_POST['action'] === 'delete' && isset($_POST['post_id'])) {
      $post_id = (int)$_POST['post_id'];

      if ($post_id > 0) {
        try {
          $stmt = $pdo->prepare("DELETE FROM posts WHERE id = ?");
          $stmt->execute([$post_id]);
          $deleted = $stmt->rowCount();
          if ($deleted) {
            $msg = "Post deleted successfully.";
            $msg_type = "success";
          } else {
            $msg = "Post not found or already deleted.";
            $msg_type = "warning";
          }
        } catch (Exception $e) {
          $msg = "Could not delete post, please try again.";
          $msg_type = "danger";
        }
      } else {
        $msg = "Invalid post id.";
        $msg_type = "warning";
      }

    /* CREATE OR UPDATE POST */
    } else {

      $editing_post_id = isset($_POST['post_id']) ? (int)$_POST['post_id'] : 0;
      $title    = trim($_POST['title'] ?? "");
      $category = trim($_POST['category'] ?? "");
      $excerpt  = trim($_POST['excerpt'] ?? "");
      $content  = $_POST['content'] ?? "";
      $cover_url = $_POST['existing_cover_url'] ?? "";
      $upload_error = "";

      /* HANDLE COVER UPLOAD IF PROVIDED */
      if (!empty($_FILES['cover']) && $_FILES['cover']['error'] !== UPLOAD_ERR_NO_FILE) {

        $err = $_FILES['cover']['error'];

        if ($err === UPLOAD_ERR_OK) {

          $tmp  = $_FILES['cover']['tmp_name'];
          $name = $_FILES['cover']['name'];
          $size = (int)$_FILES['cover']['size'];

          if ($size > 0 && $size <= 5 * 1024 * 1024) {

            $allowedMime = ['image/jpeg','image/png','image/gif','image/webp'];
            $mime = null;

            if (class_exists('finfo')) {
              $finfo = new finfo(FILEINFO_MIME_TYPE);
              $mime = $finfo->file($tmp);
            } elseif (function_exists('mime_content_type')) {
              $mime = mime_content_type($tmp);
            } else {
              $gi = @getimagesize($tmp);
              $mime = $gi['mime'] ?? null;
            }

            if ($mime && in_array($mime, $allowedMime, true)) {

              $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
              $map = [
                'image/jpeg' => 'jpg',
                'image/png'  => 'png',
                'image/gif'  => 'gif',
                'image/webp' => 'webp'
              ];
              if (!in_array($ext, ['jpg','jpeg','png','gif','webp'], true)) {
                $ext = $map[$mime] ?? 'jpg';
              }

              $fname   = date('Ymd_His') . '_' . bin2hex(random_bytes(8)) . '.' . $ext;
              $destDir = __DIR__ . '/../assets/uploads/';
              if (!is_dir($destDir)) {
                @mkdir($destDir, 0755, true);
              }

              $destPath = $destDir . $fname;

              if (@move_uploaded_file($tmp, $destPath)) {
                // store relative path, blog cards will use it
                $cover_url = 'assets/uploads/' . $fname;
              } else {
                $upload_error = "Cover image could not be saved. Please check folder permissions for assets/uploads.";
              }

            } else {
              $upload_error = "Unsupported image type for cover image.";
            }

          } else {
            $upload_error = "Cover image is too large or empty.";
          }

        } else {
          $upload_error = "Error during file upload.";
        }
      }

      if ($title && $category && $excerpt && $content) {

        try {
          if ($editing_post_id > 0) {
            /* UPDATE EXISTING */
            $stmt = $pdo->prepare("
              UPDATE posts
              SET title = ?, category = ?, excerpt = ?, cover_url = ?, content = ?
              WHERE id = ?
            ");
            $stmt->execute([$title, $category, $excerpt, $cover_url ?: null, $content, $editing_post_id]);

            $msg = $upload_error
              ? "Post updated, but, " . $upload_error
              : "Post updated successfully.";
            $msg_type = $upload_error ? "warning" : "success";

            // redirect back to edit view to avoid resubmit on refresh
            header("Location: " . $_SERVER['PHP_SELF'] . "?edit=" . $editing_post_id);
            exit;

          } else {
            /* CREATE NEW */
            $stmt = $pdo->prepare("
              INSERT INTO posts (title, category, excerpt, cover_url, content)
              VALUES (?, ?, ?, ?, ?)
            ");
            $stmt->execute([$title, $category, $excerpt, $cover_url ?: null, $content]);
            $newId = (int)$pdo->lastInsertId();

            $msg = $upload_error
              ? "Post saved, but, " . $upload_error
              : "Post saved successfully.";
            $msg_type = $upload_error ? "warning" : "success";

            // clear form fields after create
            $title = $category = $excerpt = $content = "";
            $cover_url = "";
            $editing_post_id = 0;
            $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
          }

        } catch (Exception $e) {
          $msg = "Could not save post, please try again.";
          $msg_type = "danger";
        }

      } else {
        $msg = "Please complete all fields.";
        $msg_type = "warning";
      }

    } // end save
  } // end token check
}

/* IF GET EDIT AND NOT POST, LOAD POST INTO FORM */
if ($_SERVER['REQUEST_METHOD'] !== 'POST' && $pdo && isset($_GET['edit'])) {
  $edit_id = (int)$_GET['edit'];
  if ($edit_id > 0) {
    $stmt = $pdo->prepare("
      SELECT id, title, category, excerpt, cover_url, content
      FROM posts
      WHERE id = ?
      LIMIT 1
    ");
    $stmt->execute([$edit_id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($row) {
      $editing_post_id = (int)$row['id'];
      $title    = $row['title'] ?? "";
      $category = $row['category'] ?? "";
      $excerpt  = $row['excerpt'] ?? "";
      $cover_url = $row['cover_url'] ?? "";
      $content  = $row['content'] ?? "";
    } else {
      $msg = "Post to edit not found.";
      $msg_type = "warning";
    }
  }
}

/* FETCH RECENT POSTS FOR LIST */
$recent_posts = [];
if ($pdo) {
  $stmt = $pdo->query("
    SELECT id, title, category, created_at
    FROM posts
    ORDER BY created_at DESC
    LIMIT 20
  ");
  $recent_posts = $stmt ? $stmt->fetchAll(PDO::FETCH_ASSOC) : [];
}

/* simple label logic */
$is_edit_mode = $editing_post_id > 0;
$form_heading = $is_edit_mode ? "Edit post" : "Create new post";
$primary_btn_label = $is_edit_mode ? "Update" : "Publish";
?>

<section class="section">
  <div class="container">

    <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center mb-3 gap-2">
      <div>
        <h1 class="h3 mb-1">Blog Admin</h1>
        <p class="text-muted small mb-0">
          Write, edit, upload a cover image, and publish to the MaColX blog.
        </p>
      </div>
      <div class="d-flex gap-2">
        <a href="<?php echo $base; ?>/admin/media.php" class="btn btn-outline-secondary btn-sm">Media Library</a>
        <a href="<?php echo $base; ?>/blog.php" class="btn btn-outline-secondary btn-sm">View Blog</a>
        <a href="<?php echo $_SERVER['PHP_SELF']; ?>?logout=1" class="btn btn-outline-danger btn-sm">Logout</a>
      </div>
    </div>

    <?php if ($msg): ?>
      <div class="alert alert-<?php echo htmlspecialchars($msg_type); ?> shadow-sm">
        <?php echo htmlspecialchars($msg); ?>
      </div>
    <?php endif; ?>

    <div class="row g-4">

      <!-- FORM: CREATE / EDIT -->
      <div class="col-lg-7">
        <div class="card shadow-sm border-0">
          <div class="card-body">
            <h2 class="h5 mb-3">
              <?php echo htmlspecialchars($form_heading); ?>
              <?php if ($is_edit_mode): ?>
                <span class="badge bg-light text-muted ms-1">#<?php echo (int)$editing_post_id; ?></span>
              <?php endif; ?>
            </h2>

            <form id="postForm"
                  method="post"
                  action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>"
                  class="row g-3"
                  enctype="multipart/form-data"
                  autocomplete="off">
              <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($_SESSION['csrf_token']); ?>">
              <input type="hidden" name="post_id" value="<?php echo (int)$editing_post_id; ?>">
              <input type="hidden" name="existing_cover_url" value="<?php echo htmlspecialchars($cover_url); ?>">

              <div class="col-12">
                <label class="form-label">Title</label>
                <input name="title"
                       class="form-control"
                       required
                       value="<?php echo htmlspecialchars($title); ?>">
              </div>

              <div class="col-md-6">
                <label class="form-label">Category</label>
                <input name="category"
                       list="catlist"
                       class="form-control"
                       required
                       value="<?php echo htmlspecialchars($category); ?>">
                <datalist id="catlist">
                  <option value="Analytics">
                  <option value="Digital Health">
                  <option value="Tutorial">
                  <option value="Policy">
                  <option value="News">
                </datalist>
              </div>

              <div class="col-md-6">
                <label class="form-label">Excerpt, short summary</label>
                <input name="excerpt"
                       class="form-control"
                       maxlength="400"
                       required
                       value="<?php echo htmlspecialchars($excerpt); ?>">
              </div>

              <div class="col-md-8">
                <label class="form-label">
                  Cover image
                  <?php if ($cover_url): ?>
                    <span class="text-muted small">(leave empty to keep current)</span>
                  <?php else: ?>
                    <span class="text-muted small">(optional)</span>
                  <?php endif; ?>
                </label>
                <input type="file"
                       name="cover"
                       accept="image/*"
                       class="form-control">
                <div class="form-text">PNG, JPG, GIF, WEBP, max 5 MB.</div>
              </div>

              <div class="col-md-4" id="coverPreviewWrap" <?php echo $cover_url ? '' : 'class="d-none"'; ?>>
                <label class="form-label">Preview</label>
                <div class="ratio ratio-16x9 rounded overflow-hidden border">
                  <img id="coverPreview"
                       class="img-fluid"
                       alt=""
                       src="<?php echo $cover_url ? htmlspecialchars($cover_url) : ''; ?>">
                </div>
              </div>

              <div class="col-12">
                <label class="form-label">Content Editor</label>
                <textarea id="postContent"
                          name="content"
                          rows="14"
                          class="form-control"
                          required><?php echo htmlspecialchars($content); ?></textarea>
                <div class="form-text">
                  Use the toolbar to format text, add links, or insert images.
                </div>
              </div>

              <div class="col-12 d-flex gap-2">
                <button type="button" class="btn btn-primary" id="publishBtn">
                  <?php echo htmlspecialchars($primary_btn_label); ?>
                </button>
                <?php if ($is_edit_mode): ?>
                  <a href="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" class="btn btn-outline-secondary">
                    New post
                  </a>
                <?php else: ?>
                  <a href="<?php echo $base; ?>/blog.php" class="btn btn-outline-secondary">Cancel</a>
                <?php endif; ?>
              </div>
            </form>
          </div>
        </div>
      </div>

      <!-- RECENT POSTS LIST WITH EDIT + DELETE -->
      <div class="col-lg-5">
        <div class="card shadow-sm border-0">
          <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-2">
              <h2 class="h6 mb-0">Recent posts</h2>
              <span class="badge text-bg-light">
                <?php echo count($recent_posts); ?>
              </span>
            </div>
            <p class="small text-muted mb-3">
              Quick view of the latest posts. Use edit to update and delete to remove.
            </p>

            <?php if (!$recent_posts): ?>
              <div class="alert alert-light border small mb-0">
                No posts yet. Your first post will appear here after you publish.
              </div>
            <?php else: ?>
              <div class="table-responsive">
                <table class="table align-middle table-sm mb-0">
                  <thead class="small text-muted">
                  <tr>
                    <th scope="col">Title</th>
                    <th scope="col">Category</th>
                    <th scope="col">Date</th>
                    <th scope="col" class="text-end">Actions</th>
                  </tr>
                  </thead>
                  <tbody>
                  <?php foreach ($recent_posts as $rp): ?>
                    <tr>
                      <td class="small">
                        <a href="<?php echo $base; ?>/post.php?id=<?php echo (int)$rp['id']; ?>"
                           class="text-decoration-none">
                          <?php echo htmlspecialchars(mb_strimwidth($rp['title'], 0, 38, '…')); ?>
                        </a>
                      </td>
                      <td class="small text-muted">
                        <?php echo htmlspecialchars($rp['category'] ?: ''); ?>
                      </td>
                      <td class="small text-muted">
                        <?php echo htmlspecialchars(date('M j, Y', strtotime($rp['created_at']))); ?>
                      </td>
                      <td class="text-end">
                        <a href="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>?edit=<?php echo (int)$rp['id']; ?>"
                           class="btn btn-outline-secondary btn-xs btn-sm me-1">
                          Edit
                        </a>
                        <form method="post"
                              action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>"
                              class="d-inline">
                          <input type="hidden" name="csrf_token"
                                 value="<?php echo htmlspecialchars($_SESSION['csrf_token']); ?>">
                          <input type="hidden" name="action" value="delete">
                          <input type="hidden" name="post_id" value="<?php echo (int)$rp['id']; ?>">
                          <button type="submit"
                                  class="btn btn-outline-danger btn-xs btn-sm mx-btn-delete"
                                  data-post-title="<?php echo htmlspecialchars($rp['title']); ?>">
                            Delete
                          </button>
                        </form>
                      </td>
                    </tr>
                  <?php endforeach; ?>
                  </tbody>
                </table>
              </div>
            <?php endif; ?>

          </div>
        </div>
      </div>

    </div>
  </div>
</section>

<script src="https://cdn.tiny.cloud/1/siv9y9qdlvw7yg4qchgaf5hnte9kxxcqby8u6hqex6paijkb/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
<script>
(function () {
  var endpoint = new URL('upload_image.php', window.location.href).toString();

  tinymce.init({
    selector: '#postContent',
    menubar: false,
    branding: false,
    plugins: 'link lists code table image paste',
    toolbar: 'undo redo | styles | bold italic underline | alignleft aligncenter alignright | bullist numlist | link image | table | code',
    height: 420,
    convert_urls: false,
    valid_elements: 'p,br,strong,em,span,ul,ol,li,h2,h3,h4,pre,code,table,thead,tbody,tr,th,td,a[href|target=_blank],blockquote,img[src|alt|title|width|height]',
    image_dimensions: true,
    automatic_uploads: true,
    paste_data_images: false,
    images_upload_url: endpoint,
    images_upload_handler: function (blobInfo, progress) {
      return new Promise(function (resolve, reject) {
        var xhr = new XMLHttpRequest();
        xhr.open('POST', endpoint);
        xhr.upload.onprogress = function (e) {
          if (e.lengthComputable) progress(e.loaded / e.total * 100);
        };
        xhr.onload = function () {
          if (xhr.status < 200 || xhr.status >= 300) {
            reject('HTTP error ' + xhr.status);
            return;
          }
          try {
            var json = JSON.parse(xhr.responseText);
            if (json && typeof json.location === 'string') {
              resolve(json.location);
            } else {
              reject('Invalid JSON response');
            }
          } catch (err) {
            reject('Invalid JSON');
          }
        };
        xhr.onerror = function () { reject('Upload failed'); };
        var fd = new FormData();
        fd.append('file', blobInfo.blob(), blobInfo.filename());
        fd.append('csrf_token', '<?php echo htmlspecialchars($_SESSION['csrf_token']); ?>');
        xhr.send(fd);
      });
    }
  });

  // cover preview (new upload or show existing)
  const fileInput = document.querySelector('input[name="cover"]');
  const wrap = document.getElementById('coverPreviewWrap');
  const img  = document.getElementById('coverPreview');
  if (fileInput && wrap && img) {
    fileInput.addEventListener('change', function(){
      const f = this.files && this.files[0];
      if (!f) {
        if (!img.src) {
          wrap.classList.add('d-none');
        }
        return;
      }
      const url = URL.createObjectURL(f);
      img.src = url;
      wrap.classList.remove('d-none');
    });
  }

  // publish / update button
  const form = document.getElementById('postForm');
  const btn  = document.getElementById('publishBtn');
  if (btn && form) {
    btn.addEventListener('click', function(){
      try {
        if (window.tinymce) tinymce.triggerSave();
      } catch(e) {}
      btn.disabled = true;
      form.submit();
      setTimeout(function(){ btn.disabled = false; }, 2000);
    });
  }

  // confirm delete
  document.querySelectorAll('.mx-btn-delete').forEach(function(button){
    button.addEventListener('click', function(e){
      const title = this.getAttribute('data-post-title') || 'this post';
      const ok = confirm('Are you sure you want to delete "' + title + '"?');
      if (!ok) {
        e.preventDefault();
      }
    });
  });
})();
</script>

<?php include __DIR__ . "/../includes/footer.php"; ?>
