// assets/js/site.js

// Smooth metric counters (used on Research page and can be reused elsewhere)
function initMetricCounters() {
  const counters = document.querySelectorAll('[data-mx-metric]');
  if (!counters.length) return;

  counters.forEach(counter => {
    const target = parseInt(counter.getAttribute('data-mx-metric'), 10);
    if (isNaN(target)) return;

    let current = 0;
    const duration = 1200; // ms
    const start = performance.now();

    function tick(now) {
      const progress = Math.min((now - start) / duration, 1);
      const eased = 1 - Math.pow(1 - progress, 3); // easeOutCubic
      const value = Math.floor(target * eased);

      // Pretty-print large numbers
      if (target >= 1000) {
        counter.textContent = value.toLocaleString();
      } else {
        counter.textContent = value;
      }

      if (progress < 1) requestAnimationFrame(tick);
    }

    requestAnimationFrame(tick);
  });
}

// Filter chips for research (safe: only runs if elements exist)
function initResearchFilters() {
  const chips = document.querySelectorAll('.research-filter-chip');
  const cards = document.querySelectorAll('.research-card-wrap');
  if (!chips.length || !cards.length) return;

  chips.forEach(chip => {
    chip.addEventListener('click', () => {
      chips.forEach(c => c.classList.remove('active'));
      chip.classList.add('active');

      const filter = chip.getAttribute('data-filter');
      cards.forEach(card => {
        const themes = (card.getAttribute('data-theme') || '').split(' ');
        const show = filter === 'all' || themes.includes(filter);
        card.style.display = show ? '' : 'none';
      });
    });
  });
}

// Pipeline hover highlight (Research "From field data to policy" band)
function initPipelineHover() {
  const nodes = document.querySelectorAll('.pipeline-node');
  if (!nodes.length) return;

  nodes.forEach(node => {
    node.addEventListener('mouseenter', () => {
      nodes.forEach(n => n.classList.remove('active'));
      node.classList.add('active');
    });
  });
}

// Auto-init when DOM is ready
document.addEventListener('DOMContentLoaded', function () {
  initMetricCounters();
  initResearchFilters();
  initPipelineHover();
});
