<?php
$page_title = "Blog , MaColX";
include __DIR__ . "/includes/header.php";

// Safe db
$pdo = function_exists('db') ? db() : null;

$posts = [];
$totalPosts = 0;
$totalPages = 1;

// pagination settings
$perPage = 9;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;

if ($pdo) {
  // total posts
  $totalPosts = (int)$pdo->query("SELECT COUNT(*) FROM posts")->fetchColumn();
  $totalPages = max(1, (int)ceil($totalPosts / $perPage));

  if ($page > $totalPages) {
    $page = $totalPages;
  }

  $offset = ($page - 1) * $perPage;

  // fetch page of posts
  $sql = "SELECT id, title, excerpt, category, created_at, cover_url, content
          FROM posts
          ORDER BY created_at DESC
          LIMIT :limit OFFSET :offset";
  $stmt = $pdo->prepare($sql);
  $stmt->bindValue(':limit', $perPage, PDO::PARAM_INT);
  $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
  $stmt->execute();
  $posts = $stmt->fetchAll(PDO::FETCH_ASSOC);
} else {
  $offset = 0;
}

// helper to get first image in content
if (!function_exists('first_image_src')) {
  function first_image_src($html) {
    if (!$html) return null;
    if (preg_match('/<img[^>]+src=["\']([^"\']+)["\']/i', $html, $m)) {
      return $m[1];
    }
    return null;
  }
}

// collect unique categories for filter bar (from current page only)
$categories = [];
foreach ($posts as $p) {
  $cat = trim((string)($p['category'] ?? ""));
  if ($cat !== "" && !in_array($cat, $categories, true)) {
    $categories[] = $cat;
  }
}
?>

<style>
/* Hero wrapper */
.mx-blog-hero-wrap{
  padding-top: 1.5rem;
}

/* Hero with gradient and particles */
.mx-blog-hero{
  position: relative;
  overflow: hidden;
  border-radius: 1.75rem;
  padding: 2.5rem 1.75rem;
  background: radial-gradient(circle at 0 0, #22c55e 0, rgba(34,197,94,0) 45%),
              radial-gradient(circle at 100% 0, #0ea5e9 0, rgba(14,165,233,0) 50%),
              radial-gradient(circle at 0 100%, #a855f7 0, rgba(168,85,247,0) 55%),
              linear-gradient(135deg, #020617, #020617);
  color: #f9fafb;
  box-shadow: 0 24px 60px rgba(15,23,42,0.7);
  isolation: isolate;
}
.mx-blog-hero::before{
  content: "";
  position: absolute;
  inset: -30%;
  background:
    radial-gradient(120% 120% at 10% 0, rgba(248,250,252,0.15) 0, transparent 50%),
    radial-gradient(140% 140% at 100% 60%, rgba(248,250,252,0.12) 0, transparent 55%);
  mix-blend-mode: screen;
  opacity: 0.9;
  pointer-events: none;
}
.mx-blog-hero-inner{
  position: relative;
  z-index: 2;
}

/* Floating particles */
.mx-blog-particles{
  position: absolute;
  inset: 0;
  overflow: hidden;
  z-index: 1;
  pointer-events: none;
}
.mx-blog-particle{
  position: absolute;
  width: 6px;
  height: 6px;
  border-radius: 999px;
  background: rgba(248,250,252,0.85);
  opacity: 0.7;
  box-shadow: 0 0 12px rgba(248,250,252,0.7);
  animation: mxBlogFloat 12s ease-in-out infinite;
}
.mx-blog-particle:nth-child(1){ top: 14%; left: 10%; animation-duration: 11s; }
.mx-blog-particle:nth-child(2){ top: 30%; left: 80%; animation-duration: 13s; }
.mx-blog-particle:nth-child(3){ top: 65%; left: 20%; animation-duration: 15s; }
.mx-blog-particle:nth-child(4){ top: 75%; left: 65%; animation-duration: 12s; }
.mx-blog-particle:nth-child(5){ top: 40%; left: 45%; animation-duration: 16s; }
.mx-blog-particle:nth-child(6){ top: 18%; left: 60%; animation-duration: 14s; }

@keyframes mxBlogFloat{
  0%   { transform: translate3d(0,0,0) scale(1); opacity: 0.2; }
  25%  { transform: translate3d(12px,-10px,0) scale(1.1); opacity: 0.7; }
  50%  { transform: translate3d(-6px,-18px,0) scale(0.9); opacity: 0.6; }
  75%  { transform: translate3d(8px,8px,0) scale(1.05); opacity: 0.9; }
  100% { transform: translate3d(0,0,0) scale(1); opacity: 0.2; }
}

/* Hero text */
.mx-blog-kicker{
  font-size: .8rem;
  letter-spacing: .18em;
  text-transform: uppercase;
  color: #a5b4fc;
}
.mx-blog-title{
  font-size: clamp(1.9rem, 3vw, 2.35rem);
}
.mx-blog-sub{
  max-width: 38rem;
  font-size: .9rem;
}

/* Hero meta pills */
.mx-blog-meta-pill{
  display: inline-flex;
  align-items: center;
  gap: .35rem;
  padding: .35rem .8rem;
  border-radius: 999px;
  background: rgba(15,23,42,0.85);
  border: 1px solid rgba(148,163,184,0.55);
  font-size: .78rem;
  color: #e5e7eb;
  backdrop-filter: blur(16px);
}
.mx-blog-meta-dot{
  width: .45rem;
  height: .45rem;
  border-radius: 999px;
  background: #22c55e;
  box-shadow: 0 0 0 .18rem rgba(34,197,94,0.4);
}

/* Filter bar */
.mx-blog-filters-wrap{
  margin-top: 1.5rem;
}
.mx-blog-filters{
  border-radius: 999px;
  padding: .25rem;
  background: rgba(15,23,42,0.08);
  backdrop-filter: blur(12px);
  display: inline-flex;
}
.mx-blog-filters .btn{
  border: none;
  font-size: .8rem;
}
.mx-blog-filters .btn.active{
  background: #0f766e;
  color: #ecfeff;
}

/* List section */
.mx-blog-list-section{
  padding-top: 2.5rem;
}

/* Cards */
.mx-blog-card{
  border-radius: 1.25rem;
  border: 1px solid rgba(148,163,184,0.25);
  background:
    radial-gradient(circle at 0 0, rgba(56,189,248,0.06) 0, transparent 45%),
    radial-gradient(circle at 100% 100%, rgba(34,197,94,0.06) 0, transparent 45%),
    #ffffff;
  box-shadow: 0 18px 40px rgba(15,23,42,0.06);
  overflow: hidden;
  display: flex;
  flex-direction: column;
  transform: translateY(0);
  transition: transform .25s ease, box-shadow .25s ease, border .25s ease;
}
.mx-blog-card:hover{
  transform: translateY(-6px);
  box-shadow: 0 26px 60px rgba(15,23,42,0.12);
  border-color: rgba(56,189,248,0.6);
}

/* Thumbnail wrapper, contain full image, no black bars */
.mx-blog-thumb{
  position: relative;
  width: 100%;
  border-radius: 1rem 1rem 0 0;
  overflow: hidden;
  display: flex;
  align-items: center;
  justify-content: center;
  background: #ffffff;              /* same as card background */
}
.mx-blog-thumb img{
  max-width: 100%;
  max-height: 230px;                /* keeps cards visually even */
  width: auto;
  height: auto;
  display: block;
  object-fit: contain;              /* show entire image */
  object-position: center center;
  transition: transform .45s ease, opacity .45s ease;
  opacity: .98;
}
.mx-blog-card:hover .mx-blog-thumb img{
  transform: scale(1.03);
  opacity: 1;
}

.mx-blog-thumb-overlay{
  position: absolute;
  inset: 0;
  background: linear-gradient(to top, rgba(15,23,42,0.45), rgba(15,23,42,0));
  opacity: 0;
  transition: opacity .3s ease;
}
.mx-blog-card:hover .mx-blog-thumb-overlay{
  opacity: 1;
}

/* Placeholder if no image */
.mx-blog-thumb-placeholder{
  border-radius: 1rem 1rem 0 0;
  height: 190px;
  background: radial-gradient(circle at 0 0, #0ea5e9 0, rgba(14,165,233,0) 55%),
              radial-gradient(circle at 100% 100%, #22c55e 0, rgba(34,197,94,0) 55%),
              #020617;
  display: flex;
  align-items: flex-end;
  justify-content: flex-start;
  padding: .9rem 1rem;
  color: #e5e7eb;
  font-size: .8rem;
}

/* Card body */
.mx-blog-card-body{
  padding: 1rem 1rem 1.1rem;
}
.mx-blog-category-badge{
  font-size: .72rem;
  padding: .2rem .6rem;
  border-radius: 999px;
  background: rgba(15,23,42,0.03);
  color: #0f172a;
  border: 1px solid rgba(148,163,184,0.6);
  text-transform: uppercase;
  letter-spacing: .12em;
}
.mx-blog-title-link{
  color: #020617;
  text-decoration: none;
}
.mx-blog-title-link:hover{
  color: #0f766e;
}
.mx-blog-excerpt{
  font-size: .85rem;
  color: #4b5563;
}
.mx-blog-footer{
  font-size: .75rem;
  color: #6b7280;
  display: flex;
  justify-content: space-between;
  align-items: center;
}
.mx-blog-read-link{
  text-decoration: none;
  font-weight: 500;
  font-size: .8rem;
  color: #0f766e;
}
.mx-blog-read-link:hover{
  text-decoration: underline;
}

/* Empty state */
.mx-blog-empty{
  border-radius: 1rem;
  border: 1px dashed rgba(148,163,184,0.6);
  padding: 1.5rem;
  background: rgba(248,250,252,0.9);
}

/* Scroll reveal */
.mx-blog-card{
  opacity: 0;
  transform: translateY(14px);
}
.mx-blog-card.mx-in{
  opacity: 1;
  transform: translateY(0);
  transition: opacity .5s ease, transform .5s ease;
}

/* Pagination */
.mx-blog-pagination{
  margin-top: 2rem;
}
.mx-blog-pagination .page-link{
  border-radius: 999px;
  font-size: .85rem;
}

/* Mobile tweaks */
@media (max-width: 767.98px){
  .mx-blog-hero{
    padding: 1.8rem 1.3rem;
    border-radius: 1.3rem;
  }
  .mx-blog-title{
    font-size: 1.6rem;
  }
  .mx-blog-sub{
    font-size: .85rem;
  }
  .mx-blog-filters-wrap{
    justify-content: flex-start;
  }
  .mx-blog-filters{
    max-width: 100%;
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
    white-space: nowrap;
  }
}

/* Respect reduced motion */
@media (prefers-reduced-motion: reduce){
  .mx-blog-hero::before,
  .mx-blog-particle,
  .mx-blog-card,
  .mx-blog-card:hover,
  .mx-blog-thumb img,
  .mx-blog-card.mx-in{
    animation: none !important;
    transition: none !important;
    transform: none !important;
  }
}
</style>

<section class="section mx-blog-hero-wrap">
  <div class="container">
    <div class="mx-blog-hero">
      <div class="mx-blog-particles">
        <span class="mx-blog-particle"></span>
        <span class="mx-blog-particle"></span>
        <span class="mx-blog-particle"></span>
        <span class="mx-blog-particle"></span>
        <span class="mx-blog-particle"></span>
        <span class="mx-blog-particle"></span>
      </div>

      <div class="mx-blog-hero-inner">
        <div class="row align-items-center gy-4">
          <div class="col-lg-7">
            <div class="mx-blog-kicker mb-2">
              Blog , MaColX
            </div>
            <h1 class="mx-blog-title fw-semibold mb-2">
              Reflections on digital health , data , and delivery
            </h1>
            <p class="mx-blog-sub mb-3">
              Short pieces on building dependable health information systems , analytics that teams can trust ,
              and lessons from work with Ghana Health Service and partners.
            </p>

            <div class="d-flex flex-wrap align-items-center gap-2">
              <span class="mx-blog-meta-pill">
                <span class="mx-blog-meta-dot"></span>
                <span><?php echo $totalPosts; ?> posts</span>
              </span>
              <span class="mx-blog-meta-pill">
                <span class="mx-blog-meta-dot" style="background:#0ea5e9; box-shadow:0 0 0 .18rem rgba(14,165,233,0.4);"></span>
                <span>Digital health , analytics , programme practice</span>
              </span>
            </div>
          </div>

          <div class="col-lg-5">
            <div class="text-lg-end small">
              <p class="mb-2 text-light">
                Some themes you will see
              </p>
              <div class="d-inline-flex flex-wrap gap-2 justify-content-lg-end">
                <span class="mx-blog-meta-pill">Data quality in routine systems</span>
                <span class="mx-blog-meta-pill">Dashboards for decision makers</span>
                <span class="mx-blog-meta-pill">Community health and field tools</span>
              </div>
            </div>
          </div>
        </div>

        <?php if (!empty($categories)): ?>
          <div class="mx-blog-filters-wrap d-flex justify-content-center justify-content-md-start">
            <div class="mx-blog-filters d-inline-flex flex-wrap gap-1 mt-3">
              <button type="button" class="btn btn-sm rounded-pill active" data-blog-filter="all">
                All topics
              </button>
              <?php foreach ($categories as $cat): ?>
                <button
                  type="button"
                  class="btn btn-sm rounded-pill"
                  data-blog-filter="<?php echo htmlspecialchars($cat); ?>">
                  <?php echo htmlspecialchars($cat); ?>
                </button>
              <?php endforeach; ?>
            </div>
          </div>
        <?php endif; ?>

      </div>
    </div>
  </div>
</section>

<section class="section mx-blog-list-section">
  <div class="container">
    <div class="row g-4">

      <?php if (!$posts): ?>
        <div class="col-12">
          <div class="mx-blog-empty">
            <p class="mb-1 fw-semibold">No posts yet</p>
            <p class="mb-0 small text-muted">
              Use the admin page to add your first article , perhaps a short note on a recent dashboard or project.
            </p>
          </div>
        </div>
      <?php endif; ?>

      <?php foreach ($posts as $p): ?>
        <?php
          $thumb = $p['cover_url'] ?: first_image_src($p['content'] ?? '');
          $cat   = trim((string)($p['category'] ?? ""));
        ?>
        <div
          class="col-12 col-md-6 col-lg-4 d-flex"
          data-blog-category="<?php echo htmlspecialchars($cat); ?>">
          <article class="mx-blog-card flex-fill">
            <?php if ($thumb): ?>
              <div class="mx-blog-thumb">
                <img
                  src="<?php echo htmlspecialchars($thumb); ?>"
                  alt="<?php echo htmlspecialchars($p['title']); ?>"
                  loading="lazy">
                <div class="mx-blog-thumb-overlay"></div>
              </div>
            <?php else: ?>
              <div class="mx-blog-thumb-placeholder">
                MaColX blog
              </div>
            <?php endif; ?>

            <div class="mx-blog-card-body">
              <?php if ($cat !== ""): ?>
                <div class="mb-2">
                  <span class="mx-blog-category-badge">
                    <?php echo htmlspecialchars($cat); ?>
                  </span>
                </div>
              <?php endif; ?>

              <h2 class="h5 mb-2">
                <a
                  href="<?php echo $base; ?>/post.php?id=<?php echo (int)$p['id']; ?>"
                  class="mx-blog-title-link">
                  <?php echo htmlspecialchars($p['title']); ?>
                </a>
              </h2>

              <?php if (!empty($p['excerpt'])): ?>
                <p class="mx-blog-excerpt mb-3">
                  <?php echo htmlspecialchars($p['excerpt']); ?>
                </p>
              <?php endif; ?>

              <div class="mx-blog-footer">
                <span>
                  <?php echo date('M j, Y', strtotime($p['created_at'])); ?>
                </span>
                <a
                  href="<?php echo $base; ?>/post.php?id=<?php echo (int)$p['id']; ?>"
                  class="mx-blog-read-link">
                  Read more
                </a>
              </div>
            </div>
          </article>
        </div>
      <?php endforeach; ?>

    </div>

    <?php if ($totalPages > 1): ?>
      <nav class="mx-blog-pagination" aria-label="Blog pagination">
        <ul class="pagination justify-content-center">

          <!-- Previous -->
          <li class="page-item <?php echo $page <= 1 ? 'disabled' : ''; ?>">
            <a class="page-link"
               href="<?php echo $page <= 1 ? '#' : $base . '/blog.php?page=' . ($page - 1); ?>"
               tabindex="<?php echo $page <= 1 ? '-1' : '0'; ?>">
              Previous
            </a>
          </li>

          <!-- Page numbers -->
          <?php
            $start = max(1, $page - 2);
            $end   = min($totalPages, $page + 2);
            for ($i = $start; $i <= $end; $i++):
          ?>
            <li class="page-item <?php echo $i === $page ? 'active' : ''; ?>">
              <a class="page-link"
                 href="<?php echo $base; ?>/blog.php?page=<?php echo $i; ?>">
                <?php echo $i; ?>
              </a>
            </li>
          <?php endfor; ?>

          <!-- Next -->
          <li class="page-item <?php echo $page >= $totalPages ? 'disabled' : ''; ?>">
            <a class="page-link"
               href="<?php echo $page >= $totalPages ? '#' : $base . '/blog.php?page=' . ($page + 1); ?>"
               tabindex="<?php echo $page >= $totalPages ? '-1' : '0'; ?>">
              Next
            </a>
          </li>

        </ul>
      </nav>
    <?php endif; ?>

  </div>
</section>

<script>
// Category filter for blog
(function(){
  const buttons = document.querySelectorAll("[data-blog-filter]");
  const cards   = document.querySelectorAll("[data-blog-category]");
  if (!buttons.length || !cards.length) return;

  buttons.forEach(btn => {
    btn.addEventListener("click", () => {
      const tag = btn.getAttribute("data-blog-filter");

      buttons.forEach(b => b.classList.remove("active"));
      btn.classList.add("active");

      cards.forEach(card => {
        const cat = card.getAttribute("data-blog-category") || "";
        if (tag === "all" || cat === tag) {
          card.classList.remove("d-none");
        } else {
          card.classList.add("d-none");
        }
      });
    });
  });
})();

// Reveal on scroll
(function(){
  const cards = document.querySelectorAll(".mx-blog-card");
  if (!("IntersectionObserver" in window) || !cards.length) {
    cards.forEach(c => c.classList.add("mx-in"));
    return;
  }

  const io = new IntersectionObserver(entries => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        entry.target.classList.add("mx-in");
        io.unobserve(entry.target);
      }
    });
  }, { threshold: 0.15 });

  cards.forEach(card => io.observe(card));
})();
</script>

<?php include __DIR__ . "/includes/footer.php"; ?>
