<?php
// MaColX config.php — single source of truth
declare(strict_types=1);

// --- Local defaults ---
$localCreds = [
  'DB_HOST' => '127.0.0.1',
  'DB_PORT' => '3306',
  'DB_NAME' => 'macolx',
  'DB_USER' => 'root',
  'DB_PASS' => '/@h@4cFr1YXtipqa',
];

// --- Online / production credentials ---
$onlineCreds = [
  'DB_HOST' => getenv('DB_HOST') ?: 'localhost',
  'DB_PORT' => getenv('DB_PORT') ?: '3306',
  'DB_NAME' => getenv('DB_NAME') ?: 'senavibe_macolx',
  'DB_USER' => getenv('DB_USER') ?: 'senavibe_user',
  'DB_PASS' => getenv('DB_PASS') ?: 'bWkTKS7>f33>X}X',
];

// --- Decide environment ---
// Simple check: if running on localhost, use local creds; otherwise use online
$isLocal = in_array($_SERVER['SERVER_NAME'] ?? 'cli', ['localhost','127.0.0.1','::1']);

// Pick credentials
$creds = $isLocal ? $localCreds : $onlineCreds;

// Define constants
foreach ($creds as $key => $val) {
  if (!defined($key)) {
    define($key, $val);
  }
}

// Optional version tag
$version = $version ?? '20251108a';

// PDO singleton
if (!function_exists('db')) {
  function db(): ?PDO {
    static $pdo = null;
    if ($pdo instanceof PDO) {
      return $pdo;
    }

    $dsn = sprintf(
      'mysql:host=%s;port=%s;dbname=%s;charset=utf8mb4',
      DB_HOST,
      DB_PORT,
      DB_NAME
    );

    try {
      $pdo = new PDO($dsn, DB_USER, DB_PASS, [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
      ]);
      $pdo->exec("SET NAMES utf8mb4");
      $pdo->exec("SET time_zone = '+00:00'");
    } catch (Throwable $e) {
      exit('Database connection failed: ' . $e->getMessage());
    }

    return $pdo;
  }
}

// Compute $base once, works at root or in subfolder
if (!isset($base)) {
  $base = rtrim(str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME'] ?? '/')), '/');
  if ($base === '/' || $base === '\\' || $base === '.') {
    $base = '';
  }
}
