<?php
// includes/header.php  – shared layout header

// Prevent double-include
if (defined('MX_HEADER_INCLUDED')) { return; }
define('MX_HEADER_INCLUDED', true);

// Always load the single root config
require_once dirname(__DIR__) . '/config.php';

// Compute $base once (used for links/assets)
$base = $base ?? rtrim(str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'] ?? '/')), '/');
if ($base === '/' || $base === '\\' || $base === '.') { $base = ''; }

// Version for cache-busting CSS
$version    = $version ?? '20251108a';
$page_title = $page_title ?? 'MaColX';
$page_desc  = $page_desc  ?? 'MaColX combines digital health, biomedical data science, and web technologies to build intelligent, scalable solutions for global health programs.';
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($page_title) ?></title>
  <meta name="description" content="<?= htmlspecialchars($page_desc) ?>">
  <meta name="author" content="Joshua Marius Acolatse, Ghana Health Service / MaColX">
  <meta name="keywords" content="digital health, biomedical data science, analytics, web development, predictive analytics, Ghana Health Service, WHO, health informatics, MaColX">

  <!-- Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">

  <!-- Bootstrap & Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Site styles -->
  <link rel="stylesheet" href="<?= $base ?>/assets/css/style.css?v=<?= $version ?>">
  <link rel="stylesheet" href="<?= $base ?>/assets/css/theme.css?v=<?= $version ?>">

  <!-- Favicon -->
  <link rel="icon" href="<?= $base ?>/assets/img/macolx_logo.png">

  <script>console.log("MaColX header build <?= $version ?>");</script>
</head>

<body>
<nav class="navbar navbar-expand-lg mx sticky-top bg-white border-bottom navbar-light">
  <div class="container">
    <a class="navbar-brand d-flex align-items-center" href="<?= $base ?>/index.php">
      <img src="<?= $base ?>/assets/img/macolx_logo.png" alt="MaColX logo" style="height:36px" class="me-2">
      <span class="fw-bold">MaColX</span>
    </a>

    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav"
            aria-controls="nav" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="nav">
      <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
        <li class="nav-item"><a class="nav-link" href="<?= $base ?>/index.php">Home</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= $base ?>/about.php">About</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= $base ?>/services.php">Services</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= $base ?>/projects.php">Projects</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= $base ?>/blog.php">Blog</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= $base ?>/research.php">Research</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= $base ?>/contact.php">Contact</a></li>

        <!-- Theme toggle button -->
        <li class="nav-item d-flex align-items-center ms-lg-3">
          <button class="btn btn-sm btn-ghost" id="themeToggle" type="button" aria-label="Toggle theme">
            <i class="bi bi-moon-stars" id="themeIcon"></i>
          </button>
        </li>
      </ul>
    </div>
  </div>
</nav>
