<?php
// v2025-11-12-idx-pro-clean-anim

$page_title = "MaColX, Digital Health and Data Science";

// header.php loads config and opens <html>/<body>/<nav>
require_once __DIR__ . "/includes/header.php";

// Get PDO only if db() exists
$pdo = function_exists('db') ? db() : null;

// Fetch latest 3 posts
$posts = [];
if ($pdo) {
  $stmt = $pdo->query("
    SELECT id, title, excerpt, cover_url, created_at, content
    FROM posts
    ORDER BY created_at DESC
    LIMIT 3
  ");
  $posts = $stmt ? $stmt->fetchAll(PDO::FETCH_ASSOC) : [];
}

// helper to extract first image from HTML
function first_image_src($html) {
  if (!$html) return null;
  if (preg_match('/<img[^>]+src=["\']([^"\']+)["\']/i', $html, $m)) return $m[1];
  return null;
}
?>

<!-- small CSS for reveal and sparklines -->



<!-- HERO, responsive slim slider -->
<style>
/* ===========================
   Reveal and metrics defaults
   =========================== */

/* Reveal effect */
.section-title{
  opacity: 0;
  transform: translateY(10px);
  transition: opacity .4s ease, transform .4s ease;
}
.section-title.reveal-in{
  opacity: 1;
  transform: translateY(0);
}

.reveal-item{
  opacity: 0;
  transform: translateY(12px);
  transition: opacity .45s ease, transform .45s ease;
}
.reveal-item.in{
  opacity: 1;
  transform: translateY(0);
}

/* Sparkline defaults */
.mx-service-spark svg{
  width: 100%;
  height: 36px;
  display: block;
}
.spark-grid{
  fill: none;
  stroke: rgba(108,117,125,.35);
  stroke-width: 1;
}
.spark-line{
  fill: none;
  stroke: currentColor;
  stroke-width: 2;
  stroke-linecap: round;
}
.spark-area{
  fill: currentColor;
  opacity: .08;
}
.spark-bar{
  fill: currentColor;
  opacity: .85;
}

/* Metric live dot */
.metrics-dot-live{
  width: 8px;
  height: 8px;
  border-radius: 50%;
  background: #16a34a;
  display: inline-block;
  box-shadow: 0 0 0 0 rgba(22,163,74,.5);
  animation: ping 1.8s cubic-bezier(0,0,.2,1) infinite;
}

/* ping animation */
@keyframes ping{
  0%   { box-shadow: 0 0 0 0 rgba(22,163,74,.45); }
  70%  { box-shadow: 0 0 0 10px rgba(22,163,74,0); }
  100% { box-shadow: 0 0 0 0 rgba(22,163,74,0); }
}

/* ===========================
   Sparkline fixed palette
   =========================== */

:root{
  --spark1: #0ea5e9; /* uptime blue */
  --spark2: #8b5cf6; /* step violet */
  --spark3: #22c55e; /* area green */
  --spark4: #f59e0b; /* pulse amber */
  --spark5: #ef4444; /* waves red */
}

/* Lines by type */
.sparkline-uptime  .spark-line-1{ stroke: var(--spark1); }
.sparkline-step    .spark-line-2{ stroke: var(--spark2); }
.sparkline-area    .spark-line-3{ stroke: var(--spark3); }
.sparkline-pulse   .spark-line-4{ stroke: var(--spark4); }
.sparkline-waves   .spark-line-5{ stroke: var(--spark5); }

/* Area fill for the green freshness chart */
.sparkline-area .spark-area{
  fill: var(--spark3);
  opacity: .12;
}

/* Bars for release cadence */
.sparkline-bars .spark-bar{
  fill: var(--spark1);
  opacity: .9;
}

/* Keep grid subtle */
.mx-service-spark .spark-grid{
  stroke: rgba(0,0,0,.08);
}

/* ===========================
   Hero, lighting and motion
   =========================== */

.mx-hero{
  position: relative;
}

/* viewport wrapper */
.mx-hero .slide-viewport{
  position: relative;
  overflow: hidden;
  isolation: isolate;
}

/* image parallax target */
.mx-hero .slide-img{
  width: 100%;
  display: block;
  will-change: transform;
  transition: transform 500ms cubic-bezier(.2,.6,.2,1);
}

/* animated gradient layer */
.mx-hero .slide-viewport::before{
  content: "";
  position: absolute;
  inset: -20%;
  pointer-events: none;
  background:
    radial-gradient(40% 55% at 20% 30%, rgba(36,133,255,.28) 0%, rgba(36,133,255,0) 60%),
    radial-gradient(35% 50% at 80% 70%, rgba(0,200,83,.22) 0%, rgba(0,200,83,0) 65%),
    radial-gradient(120% 90% at 50% 50%, rgba(255,255,255,.08) 0%, rgba(255,255,255,0) 60%);
  mix-blend-mode: soft-light;
  filter: saturate(1.05);
  animation: mxGlow 14s ease-in-out infinite alternate;
  opacity: .85;
  z-index: 1;
}

/* soft highlight sweep */
.mx-hero .slide-viewport::after{
  content: "";
  position: absolute;
  inset: -10% -30%;
  background: linear-gradient(100deg, rgba(255,255,255,0) 0%, rgba(255,255,255,.08) 45%, rgba(255,255,255,0) 90%);
  transform: translateX(-25%);
  mix-blend-mode: soft-light;
  animation: mxSweep 9s ease-in-out infinite;
  pointer-events: none;
  z-index: 1;
}

/* overlay layout */
.mx-hero-overlay{
  position: absolute;
  inset: 0;
  display: flex;
  align-items: center;
  color: #0f172a;
  z-index: 2;
}

/* allow buttons to be clickable through overlay flex wrapper */
.mx-hero-overlay .btn,
.mx-hero-overlay a{
  pointer-events: auto;
}

/* extra background behind text for contrast on mobile */
.mx-hero-overlay .container{
  padding-top: 2.5rem;
  padding-bottom: 2.5rem;
}

/* gentle live dot in other sections */
.metrics-dot-live{
  width: .6rem;
  height: .6rem;
  border-radius: 999px;
  display: inline-block;
  background: #20c997;
  box-shadow: 0 0 0 .2rem rgba(32,201,151,.15);
  animation: mxPulse 2s ease-in-out infinite;
}

/* keyframes */
@keyframes mxGlow{
  0%   { transform: translate3d(-2%, -2%, 0) scale(1.02) rotate(0.2deg); }
  50%  { transform: translate3d(1%, 2%, 0) scale(1.03) rotate(-0.2deg); }
  100% { transform: translate3d(3%, -1%, 0) scale(1.02) rotate(0.15deg); }
}
@keyframes mxSweep{
  0%   { transform: translateX(-35%) rotate(0.001deg); opacity: .06; }
  50%  { transform: translateX(10%)  rotate(0.001deg); opacity: .10; }
  100% { transform: translateX(35%) rotate(0.001deg); opacity: .06; }
}
@keyframes mxPulse{
  0%,100%{ box-shadow: 0 0 0 .2rem rgba(32,201,151,.15); }
  50%    { box-shadow: 0 0 0 .35rem rgba(32,201,151,.22); }
}

/* ===========================
   Mobile tweaks for hero
   =========================== */

@media (max-width: 767.98px){
  .mx-hero{
    border-radius: 1.25rem;
  }

  .mx-hero .slide-img{
    height: 360px;
    object-fit: cover;
  }

  .mx-hero-overlay{
    align-items: flex-end;
    background: linear-gradient(to top, rgba(15,23,42,0.82), rgba(15,23,42,0.15), rgba(15,23,42,0));
    color: #f9fafb;
  }

  .mx-hero-overlay .container{
    padding-top: 3rem;
    padding-bottom: 2.1rem;
  }

  .mx-hero-overlay .mx-badge{
    background: rgba(15,23,42,0.85);
    color: #e5f3ff;
  }

  .mx-hero-overlay h1,
  .mx-hero-overlay h2{
    font-size: 1.75rem;
    line-height: 1.25;
  }

  .mx-hero-overlay .lead{
    font-size: 0.98rem;
    color: rgba(226,232,240,0.9);
  }

  .mx-hero-overlay .btn{
    margin-bottom: 0.25rem;
  }
}

/* motion respect */
@media (prefers-reduced-motion: reduce){
  .mx-hero .slide-viewport::before,
  .mx-hero .slide-viewport::after,
  .metrics-dot-live{
    animation: none;
  }
  .mx-hero .slide-img{
    transition: none;
  }
  .reveal-item,
  .reveal-item.in{
    transition: none;
  }
}
</style>

<!-- HERO, responsive slim slider -->
<section class="section pt-0">
  <div id="heroCarousel"
       class="carousel slide carousel-fade mx-hero rounded-4 overflow-hidden shadow-lg"
       data-bs-ride="carousel"
       data-bs-interval="6000"
       aria-label="Hero carousel">
    <div class="carousel-inner">

      <!-- Slide 1 -->
      <div class="carousel-item active">
        <div class="slide-viewport">
          <picture>
            <!-- WebP for large and medium screens -->
            <source type="image/webp"
                    media="(min-width:1200px)"
                    srcset="<?= $base ?>/assets/hero/med.jpg">
            <source type="image/webp"
                    media="(min-width:768px)"
                    srcset="<?= $base ?>/assets/hero/med.jpg">
            <source type="image/webp"
                    srcset="<?= $base ?>/assets/hero/med.jpg">

            <!-- JPEG fallback for all devices including mobile -->
            <img src="<?= $base ?>/assets/hero/img3.jpeg"
                 alt="MaColX hero"
                 class="slide-img w-100"
                 loading="eager"
                 decoding="async">
          </picture>

          <div class="mx-hero-overlay">
            <div class="container">
              <div class="row">
                <div class="col-lg-7">
                  <span class="mx-badge mb-3">MaColX</span>
                  <!-- <h1 class="display-6 fw-bold mb-3">
                    Digital health and data science that deliver results
                  </h1> -->
                  <br></br>
                  <div class="d-flex gap-3 flex-wrap">
                    <button class="btn btn-mx btn-lg" data-bs-toggle="modal" data-bs-target="#leadModal">
                      Start a project
                    </button>
                    <a class="btn btn-ghost btn-lg" href="<?= $base ?>/projects.php">See projects</a>
                  </div>
                </div>
              </div>
            </div>
          </div>

        </div>
      </div>

      <!-- Slide 2 -->
      <div class="carousel-item">
        <div class="slide-viewport">
          <picture>
            <!-- WebP for large and medium screens -->
            <source type="image/webp"
                    media="(min-width:1200px)"
                    srcset="<?= $base ?>/assets/hero/1.jpg">
            <source type="image/webp"
                    media="(min-width:768px)"
                    srcset="<?= $base ?>/assets/hero/1.jpg">
            <source type="image/webp"
                    srcset="<?= $base ?>/assets/hero/1.jpg">

            <!-- JPEG fallback -->
            <img src="<?= $base ?>/assets/hero/img2.jpeg"
                 alt="Predictive analytics"
                 class="slide-img w-100"
                 loading="lazy"
                 decoding="async">
          </picture>

          <div class="mx-hero-overlay">
            <div class="container">
              <div class="row">
                <div class="col-lg-7">
                  <span class="mx-badge mb-3">Analytics</span>
                  <!-- <h2 class="h1 fw-semibold mb-3">Predictive insight teams can explain and trust</h2> -->
                 <br></br>
                  <a class="btn btn-mx" href="<?= $base ?>/blog.php">Read insights</a>
                </div>
              </div>
            </div>
          </div>

        </div>
      </div>

      <!-- Slide 3 -->
      <div class="carousel-item">
        <div class="slide-viewport">
          <picture>
            <!-- WebP for large and medium screens -->
            <source type="image/webp"
                    media="(min-width:1200px)"
                    srcset="<?= $base ?>/assets/hero/data.jpg">
            <source type="image/webp"
                    media="(min-width:768px)"
                    srcset="<?= $base ?>/assets/hero/data.jpg">
            <source type="image/webp"
                    srcset="<?= $base ?>/assets/hero/data.jpg">

            <!-- JPEG fallback -->
            <img src="<?= $base ?>/assets/hero/img9.jpeg"
                 alt="Delivery quality"
                 class="slide-img w-100"
                 loading="lazy"
                 decoding="async">
          </picture>

          <div class="mx-hero-overlay">
            <div class="container">
              <div class="row">
                <div class="col-lg-7">
                  <span class="mx-badge mb-3">Delivery</span>
                  <!-- <h2 class="h1 fw-semibold mb-3">From prototype to production with quality</h2> -->
                  <a class="btn btn-ghost" href="<?= $base ?>/services.php">All services</a>
                </div>
              </div>
            </div>
          </div>

        </div>
      </div>

    </div>

    <button class="carousel-control-prev" type="button"
            data-bs-target="#heroCarousel" data-bs-slide="prev"
            aria-label="Previous">
      <span class="carousel-control-prev-icon" aria-hidden="true"></span>
    </button>
    <button class="carousel-control-next" type="button"
            data-bs-target="#heroCarousel" data-bs-slide="next"
            aria-label="Next">
      <span class="carousel-control-next-icon" aria-hidden="true"></span>
    </button>
  </div>
</section>



<!-- VALUE PILLARS -->
<section class="section section-pillars">
  <div class="container">
    <div class="row justify-content-between align-items-end mb-4">
      <div class="col-md-8">
        <h2 class="h6 text-uppercase text-muted mb-1 section-title">
          Where MaColX adds value
        </h2>
        <p class="mb-0 text-muted small">
          Focused capabilities that connect data, platforms, and teams for better decisions.
        </p>
      </div>
    </div>

    <div class="row g-4 pillars-row" data-reveal-group>
      <div class="col-12 col-md-6 col-lg-3 d-flex">
        <div class="card mx-glass mx-card-hover mx-pillar-card mx-pillar-1 flex-fill">
          <div class="card-body">
            <div class="mx-pillar-icon">
              <i class="bi bi-diagram-3"></i>
            </div>
            <h3 class="h6 text-uppercase mb-2">Digital transformation</h3>
            <p class="m-0 text-muted small">
              Modern health information systems with interoperability, automation,
              and cloud first design that respects data governance and national ownership.
            </p>
          </div>
        </div>
      </div>

      <div class="col-12 col-md-6 col-lg-3 d-flex">
        <div class="card mx-glass mx-card-hover mx-pillar-card mx-pillar-2 flex-fill">
          <div class="card-body">
            <div class="mx-pillar-icon">
              <i class="bi bi-activity"></i>
            </div>
            <h3 class="h6 text-uppercase mb-2">Biomedical data science</h3>
            <p class="m-0 text-muted small">
              Predictive modeling and outcomes forecasting with clear methods and results
              that managers and clinicians can explain and trust.
            </p>
          </div>
        </div>
      </div>

      <div class="col-12 col-md-6 col-lg-3 d-flex">
        <div class="card mx-glass mx-card-hover mx-pillar-card mx-pillar-3 flex-fill">
          <div class="card-body">
            <div class="mx-pillar-icon">
              <i class="bi bi-graph-up-arrow"></i>
            </div>
            <h3 class="h6 text-uppercase mb-2">Data innovation</h3>
            <p class="m-0 text-muted small">
              Automated pipelines, dashboards, and linkage across sources for timely
              program visibility and early risk detection.
            </p>
          </div>
        </div>
      </div>

      <div class="col-12 col-md-6 col-lg-3 d-flex">
        <div class="card mx-glass mx-card-hover mx-pillar-card mx-pillar-4 flex-fill">
          <div class="card-body">
            <div class="mx-pillar-icon">
              <i class="bi bi-globe2"></i>
            </div>
            <h3 class="h6 text-uppercase mb-2">Global collaboration</h3>
            <p class="m-0 text-muted small">
              Partnerships that translate research into operations, connecting policy,
              field teams, and technology for measurable outcomes.
            </p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- TRUST STRIP / PARTNERS -->
<section class="section section-partners">
  <div class="container">
    <div class="text-center mb-4">
      <div class="partners-label small text-uppercase">Trusted collaborators and partners</div>
      <p class="partners-sub small mb-0">
        Long term work with ministries, UN agencies, and development partners.
      </p>
    </div>

    <div class="partners-row">
      <div class="partners-marquee">
        <div class="partners-track">

          <!-- Ghana Health Service -->
          <div class="partner-pill">
            <div class="partner-glow"></div>
            <img src="<?= $base ?>/assets/trust/ghs_logo.jpeg"
                 alt="Ghana Health Service"
                 class="partner-logo">
          </div>

          <!-- Ministry of Health, Ghana -->
          <div class="partner-pill">
            <div class="partner-glow"></div>
            <img src="<?= $base ?>/assets/trust/ministry.jpg"
                 alt="Ministry of Health, Ghana"
                 class="partner-logo">
          </div>

          <!-- WHO Ghana -->
          <div class="partner-pill">
            <div class="partner-glow"></div>
            <img src="<?= $base ?>/assets/trust/who_gh.png"
                 alt="World Health Organization Ghana"
                 class="partner-logo">
          </div>

          <!-- HHFA -->
          <div class="partner-pill">
            <div class="partner-glow"></div>
            <img src="<?= $base ?>/assets/trust/hhfa.png"
                 alt="HHFA survey"
                 class="partner-logo">
          </div>

          <!-- duplicate set for seamless loop -->
          <div class="partner-pill">
            <div class="partner-glow"></div>
            <img src="<?= $base ?>/assets/trust/ghs_logo.jpeg"
                 alt="Ghana Health Service"
                 class="partner-logo">
          </div>

          <div class="partner-pill">
            <div class="partner-glow"></div>
            <img src="<?= $base ?>/assets/trust/ministry.jpg"
                 alt="Ministry of Health, Ghana"
                 class="partner-logo">
          </div>

          <div class="partner-pill">
            <div class="partner-glow"></div>
            <img src="<?= $base ?>/assets/trust/who_gh.png"
                 alt="World Health Organization Ghana"
                 class="partner-logo">
          </div>

          <div class="partner-pill">
            <div class="partner-glow"></div>
            <img src="<?= $base ?>/assets/trust/hhfa.png"
                 alt="HHFA survey"
                 class="partner-logo">
          </div>

        </div>
      </div>
    </div>
  </div>
</section>

<!-- SERVICES -->
<!-- SERVICES -->
<section class="section section-services">
  <div class="container">
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-end gap-3 mb-4">
      <div>
        <h2 class="h1 m-0 section-title">Professional services</h2>
        <p class="text-muted small mb-0">
          Digital health, data science, global public health monitoring and evaluation, research, information technology, training, and programme delivery.
        </p>
      </div>
      <div class="mt-3 mt-md-0">
        <button class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#leadModal">
          Book a consult
        </button>
      </div>
    </div>

    <div class="row" data-reveal-group>
      <div class="col-12 col-xl-11 mx-auto">
        <div class="card mx-glass mx-card-hover mx-service-card mx-service-panel h-100">
          <div class="card-body">

            <div class="d-flex justify-content-between align-items-center mb-3">
              <div>
                <h3 class="h6 text-uppercase mb-1">Service overview</h3>
                <p class="small text-muted mb-0">
                  Connected services across systems, data, public health, and delivery.
                </p>
              </div>
              <span class="mx-service-tag">Health and IT</span>
            </div>

            <div class="row g-3 mx-service-grid">

              <!-- 1. Digital health systems development -->
              <div class="col-md-6 col-lg-4 d-flex">
                <div class="mx-mini-service flex-fill">
                  <div class="d-flex align-items-start gap-2 mb-2">
                    <div class="mx-mini-icon">
                      <i class="bi bi-activity"></i>
                    </div>
                    <div>
                      <div class="small text-uppercase fw-semibold text-muted">Systems</div>
                      <h4 class="h6 mb-0">Digital health systems development</h4>
                    </div>
                  </div>
                  <p class="small text-muted mb-2">
                    Practical digital tools for clinics, communities, and national programmes, including mobile apps and platforms linked to DHIMS2 and other health information systems.
                  </p>
                  <div class="d-flex justify-content-between align-items-end mx-mini-metric">
                    <div class="mx-mini-metric-label small text-muted text-uppercase">
                      System uptime
                    </div>
                    <div class="mx-service-spark mx-mini-spark sparkline-uptime">
                      <svg viewBox="0 0 100 24" preserveAspectRatio="none" aria-hidden="true">
                        <path class="spark-grid" d="M0 18 H100" />
                        <path class="spark-line spark-line-1"
                              d="M0 18 L18 17 L36 16 L54 14 L72 13 L88 12 L100 11" />
                      </svg>
                    </div>
                  </div>
                </div>
              </div>

              <!-- 2. Biomedical and health data science -->
              <div class="col-md-6 col-lg-4 d-flex">
                <div class="mx-mini-service flex-fill">
                  <div class="d-flex align-items-start gap-2 mb-2">
                    <div class="mx-mini-icon">
                      <i class="bi bi-cpu"></i>
                    </div>
                    <div>
                      <div class="small text-uppercase fw-semibold text-muted">Models</div>
                      <h4 class="h6 mb-0">Biomedical and health data science</h4>
                    </div>
                  </div>
                  <p class="small text-muted mb-2">
                    Advanced analytics to turn routine data into useful risk scores, surveillance models, and insights for biomedical and genomic datasets.
                  </p>
                  <div class="d-flex justify-content-between align-items-end mx-mini-metric">
                    <div class="mx-mini-metric-label small text-muted text-uppercase">
                      Model stability
                    </div>
                    <div class="mx-service-spark mx-mini-spark sparkline-step">
                      <svg viewBox="0 0 100 24" preserveAspectRatio="none" aria-hidden="true">
                        <path class="spark-grid" d="M0 18 H100" />
                        <polyline class="spark-line spark-line-2"
                                  points="0,18 18,18 18,14 40,14 40,11 64,11 64,8 82,8 82,6 100,6" />
                      </svg>
                    </div>
                  </div>
                </div>
              </div>

              <!-- 3. Research, evidence and analytics -->
              <div class="col-md-6 col-lg-4 d-flex">
                <div class="mx-mini-service flex-fill">
                  <div class="d-flex align-items-start gap-2 mb-2">
                    <div class="mx-mini-icon">
                      <i class="bi bi-journal-text"></i>
                    </div>
                    <div>
                      <div class="small text-uppercase fw-semibold text-muted">Evidence</div>
                      <h4 class="h6 mb-0">Research, evidence and analytics</h4>
                    </div>
                  </div>
                  <p class="small text-muted mb-2">
                    Study design, analysis, and reporting that support decision making for ministries, partners, and universities.
                  </p>
                  <div class="d-flex justify-content-between align-items-end mx-mini-metric">
                    <div class="mx-mini-metric-label small text-muted text-uppercase">
                      Timely outputs
                    </div>
                    <div class="mx-service-spark mx-mini-spark sparkline-pulse">
                      <svg viewBox="0 0 100 24" preserveAspectRatio="none" aria-hidden="true">
                        <path class="spark-grid" d="M0 16 H100" />
                        <polyline class="spark-line spark-line-4"
                                  points="0,16 14,16 22,10 30,17 44,8 58,17 70,12 84,18 100,14" />
                      </svg>
                    </div>
                  </div>
                </div>
              </div>

              <!-- 4. Information technology and software engineering -->
              <div class="col-md-6 col-lg-4 d-flex">
                <div class="mx-mini-service flex-fill">
                  <div class="d-flex align-items-start gap-2 mb-2">
                    <div class="mx-mini-icon">
                      <i class="bi bi-phone"></i>
                    </div>
                    <div>
                      <div class="small text-uppercase fw-semibold text-muted">Development</div>
                      <h4 class="h6 mb-0">Information technology and software engineering</h4>
                    </div>
                  </div>
                  <p class="small text-muted mb-2">
                    Reliable web and mobile applications, secure databases, and well structured health information systems for field and national teams.
                  </p>
                  <div class="d-flex justify-content-between align-items-end mx-mini-metric">
                    <div class="mx-mini-metric-label small text-muted text-uppercase">
                      Release cadence
                    </div>
                    <div class="mx-service-spark mx-mini-spark sparkline-bars">
                      <svg viewBox="0 0 100 24" preserveAspectRatio="none" aria-hidden="true">
                        <path class="spark-grid" d="M0 18 H100" />
                        <rect class="spark-bar" x="4"  y="14" width="6" height="4" />
                        <rect class="spark-bar" x="22" y="12" width="6" height="6" />
                        <rect class="spark-bar" x="40" y="9"  width="6" height="9" />
                        <rect class="spark-bar" x="58" y="7"  width="6" height="11" />
                        <rect class="spark-bar" x="76" y="5"  width="6" height="13" />
                      </svg>
                    </div>
                  </div>
                </div>
              </div>

              <!-- 5. Global public health monitoring and evaluation -->
              <div class="col-md-6 col-lg-4 d-flex">
                <div class="mx-mini-service flex-fill">
                  <div class="d-flex align-items-start gap-2 mb-2">
                    <div class="mx-mini-icon">
                      <i class="bi bi-clipboard-data"></i>
                    </div>
                    <div>
                      <div class="small text-uppercase fw-semibold text-muted">M and E</div>
                      <h4 class="h6 mb-0">Global public health monitoring and evaluation</h4>
                    </div>
                  </div>
                  <p class="small text-muted mb-2">
                    Monitoring frameworks, evaluations, indicators, and data quality improvement for national and sub national health programmes.
                  </p>
                  <div class="d-flex justify-content-between align-items-end mx-mini-metric">
                    <div class="mx-mini-metric-label small text-muted text-uppercase">
                      Programme coverage
                    </div>
                    <div class="mx-service-spark mx-mini-spark sparkline-area">
                      <svg viewBox="0 0 100 24" preserveAspectRatio="none" aria-hidden="true">
                        <path class="spark-grid" d="M0 18 H100" />
                        <path class="spark-area"
                              d="M0 18 L15 16 L30 14 L45 13 L60 11 L75 9 L90 8 L100 7 L100 24 L0 24 Z" />
                        <path class="spark-line spark-line-3"
                              d="M0 18 L15 16 L30 14 L45 13 L60 11 L75 9 L90 8 L100 7" />
                      </svg>
                    </div>
                  </div>
                </div>
              </div>

              <!-- 6. Digital health consulting and innovation -->
              <div class="col-md-6 col-lg-4 d-flex">
                <div class="mx-mini-service flex-fill">
                  <div class="d-flex align-items-start gap-2 mb-2">
                    <div class="mx-mini-icon">
                      <i class="bi bi-lightbulb"></i>
                    </div>
                    <div>
                      <div class="small text-uppercase fw-semibold text-muted">Advisory</div>
                      <h4 class="h6 mb-0">Digital health consulting and innovation</h4>
                    </div>
                  </div>
                  <p class="small text-muted mb-2">
                    Strategic guidance on digital transformation, technology adoption, governance, standards, and innovation in health systems.
                  </p>
                  <div class="d-flex justify-content-between align-items-end mx-mini-metric">
                    <div class="mx-mini-metric-label small text-muted text-uppercase">
                      Engagement
                    </div>
                    <div class="mx-service-spark mx-mini-spark sparkline-waves">
                      <svg viewBox="0 0 100 24" preserveAspectRatio="none" aria-hidden="true">
                        <path class="spark-grid" d="M0 14 H100" />
                        <path class="spark-line spark-line-5"
                              d="M0 14
                                 C10 8, 20 18, 30 14
                                 C40 8, 50 18, 60 14
                                 C70 8, 80 18, 90 14
                                 C95 11, 100 15, 100 15" />
                      </svg>
                    </div>
                  </div>
                </div>
              </div>

              <!-- 7. Data visualization and decision support -->
              <div class="col-md-6 col-lg-4 d-flex">
                <div class="mx-mini-service flex-fill">
                  <div class="d-flex align-items-start gap-2 mb-2">
                    <div class="mx-mini-icon">
                      <i class="bi bi-bar-chart"></i>
                    </div>
                    <div>
                      <div class="small text-uppercase fw-semibold text-muted">Dashboards</div>
                      <h4 class="h6 mb-0">Data visualization and decision support</h4>
                    </div>
                  </div>
                  <p class="small text-muted mb-2">
                    Clear, interactive dashboards and visual tools that guide real time decisions for managers, clinicians, and partners.
                  </p>
                  <div class="d-flex justify-content-between align-items-end mx-mini-metric">
                    <div class="mx-mini-metric-label small text-muted text-uppercase">
                      View usage
                    </div>
                    <div class="mx-service-spark mx-mini-spark">
                      <svg viewBox="0 0 100 24" preserveAspectRatio="none" aria-hidden="true">
                        <path class="spark-grid" d="M0 18 H100" />
                        <rect class="spark-bar" x="6"  y="14" width="6" height="4" />
                        <rect class="spark-bar" x="24" y="13" width="6" height="5" />
                        <rect class="spark-bar" x="42" y="10" width="6" height="8" />
                        <rect class="spark-bar" x="60" y="8"  width="6" height="10" />
                        <rect class="spark-bar" x="78" y="9"  width="6" height="9" />
                      </svg>
                    </div>
                  </div>
                </div>
              </div>

              <!-- 8. Project management and programme delivery -->
              <div class="col-md-6 col-lg-4 d-flex">
                <div class="mx-mini-service flex-fill">
                  <div class="d-flex align-items-start gap-2 mb-2">
                    <div class="mx-mini-icon">
                      <i class="bi bi-briefcase"></i>
                    </div>
                    <div>
                      <div class="small text-uppercase fw-semibold text-muted">Delivery</div>
                      <h4 class="h6 mb-0">Project management and programme delivery</h4>
                    </div>
                  </div>
                  <p class="small text-muted mb-2">
                    Leading health and technology projects from planning to implementation, with clear roles, risks, and structured learning.
                  </p>
                  <div class="d-flex justify-content-between align-items-end mx-mini-metric">
                    <div class="mx-mini-metric-label small text-muted text-uppercase">
                      Delivery rate
                    </div>
                    <div class="mx-service-spark mx-mini-spark">
                      <svg viewBox="0 0 100 24" preserveAspectRatio="none" aria-hidden="true">
                        <path class="spark-grid" d="M0 18 H100" />
                        <polyline class="spark-line"
                                  points="0,18 18,16 36,15 54,13 72,12 88,11 100,10" />
                      </svg>
                    </div>
                  </div>
                </div>
              </div>

              <!-- 9. Training and capacity building -->
              <div class="col-md-6 col-lg-4 d-flex">
                <div class="mx-mini-service flex-fill">
                  <div class="d-flex align-items-start gap-2 mb-2">
                    <div class="mx-mini-icon">
                      <i class="bi bi-people"></i>
                    </div>
                    <div>
                      <div class="small text-uppercase fw-semibold text-muted">Capacity</div>
                      <h4 class="h6 mb-0">Training and capacity building</h4>
                    </div>
                  </div>
                  <p class="small text-muted mb-2">
                    Practical workshops and mentoring for health information teams, data officers, and programme managers, using real tools and datasets from their own systems.
                  </p>
                  <div class="d-flex justify-content-between align-items-end mx-mini-metric">
                    <div class="mx-mini-metric-label small text-muted text-uppercase">
                      Participants trained
                    </div>
                    <div class="mx-service-spark mx-mini-spark sparkline-pulse">
                      <svg viewBox="0 0 100 24" preserveAspectRatio="none" aria-hidden="true">
                        <path class="spark-grid" d="M0 16 H100" />
                        <polyline class="spark-line spark-line-4"
                                  points="0,16 14,16 22,10 30,17 44,8 58,17 70,12 84,18 100,14" />
                      </svg>
                    </div>
                  </div>
                </div>
              </div>

            </div><!-- /.mx-service-grid -->

          </div>
        </div>
      </div>
    </div>

  </div>
</section>

<style>
/* Big services panel and mini cards */
.mx-service-panel{
  border-radius: 1.3rem;
}

.mx-service-grid .mx-mini-service{
  border-radius: 0.9rem;
  border: 1px solid rgba(148,163,184,0.35);
  background:
    radial-gradient(circle at 0 0, rgba(56,189,248,0.06) 0, transparent 55%),
    #ffffff;
  padding: 0.85rem 0.9rem;
  box-shadow: 0 8px 18px rgba(15,23,42,0.05);
  display: flex;
  flex-direction: column;
  transition: transform .18s ease, box-shadow .18s ease, border-color .18s ease, background .18s ease;
}

.mx-service-grid .mx-mini-service:hover{
  transform: translateY(-3px);
  border-color: rgba(56,189,248,0.7);
  box-shadow: 0 14px 30px rgba(15,23,42,0.10);
  background:
    radial-gradient(circle at 0 0, rgba(56,189,248,0.10) 0, transparent 55%),
    #ffffff;
}

.mx-mini-icon{
  width: 30px;
  height: 30px;
  border-radius: 0.75rem;
  display: flex;
  align-items: center;
  justify-content: center;
  background: #e0f2fe;
  color: #0f172a;
  font-size: 0.9rem;
}

/* mini metric strip */
.mx-mini-metric{
  margin-top: .35rem;
}

.mx-mini-metric-label{
  letter-spacing: .06em;
}

/* mini sparkline size */
.mx-mini-spark svg{
  width: 80px;
  height: 22px;
}

/* mobile tweaks */
@media (max-width: 575.98px){
  .section-services .card.mx-service-panel .card-body{
    padding: 0.9rem 0.9rem 1rem;
  }
  .mx-service-grid .mx-mini-service{
    padding: 0.75rem 0.8rem;
  }
  .mx-service-grid .mx-mini-service p.small{
    font-size: 0.8rem;
  }
}
</style>



<!-- FEATURED WORK -->
<!-- FEATURED WORK , Compact grid cards -->
<section class="section py-5 section-featured-grid">
  <div class="container">

    <div class="d-flex justify-content-between align-items-end mb-4">
      <div>
        <h2 class="h1 m-0 section-title">Featured work</h2>
        <p class="text-muted small mb-0">
          Selected digital health and analytics delivery with Ghana Health Service and partners.
        </p>
      </div>
      <a href="<?= $base ?>/projects.php"
         class="btn btn-sm btn-outline-secondary rounded-pill">
        View all
      </a>
    </div>

    <style>
      /* Section background */
      .section-featured-grid{
        background:
          radial-gradient(circle at 0 0, rgba(56,189,248,0.10) 0, transparent 45%),
          radial-gradient(circle at 100% 100%, rgba(34,197,94,0.10) 0, transparent 45%),
          #f8fafc;
      }
      .section-featured-grid .section-title{
        position: relative;
        padding-left: 1.1rem;
      }
      .section-featured-grid .section-title::before{
        content: "";
        position: absolute;
        left: 0;
        top: 50%;
        width: .35rem;
        height: 1.8rem;
        border-radius: 999px;
        background: linear-gradient(to bottom, #0ea5e9, #22c55e);
        transform: translateY(-50%);
      }

      /* Card grid */
      .mx-fw-grid{
        display: grid;
        grid-template-columns: repeat(3, minmax(0,1fr));
        gap: 1.1rem;
      }
      @media (max-width: 991.98px){
        .mx-fw-grid{
          grid-template-columns: repeat(2, minmax(0,1fr));
        }
      }
      @media (max-width: 575.98px){
        .mx-fw-grid{
          grid-template-columns: minmax(0,1fr);
        }
      }

      /* Cards */
      .mx-fw-card{
        position: relative;
        border-radius: 1.15rem;
        border: 1px solid rgba(148,163,184,0.35);
        background:
          radial-gradient(circle at 0 0, rgba(56,189,248,0.08) 0, transparent 40%),
          radial-gradient(circle at 100% 100%, rgba(34,197,94,0.08) 0, transparent 40%),
          #ffffff;
        box-shadow: 0 10px 25px rgba(15,23,42,0.06);
        padding: 1rem 1.05rem;
        text-decoration: none;
        color: inherit;
        display: flex;
        flex-direction: column;
        min-height: 170px;
        transition: transform .22s ease, box-shadow .22s ease, border-color .22s ease, background .22s ease;
      }
      .mx-fw-card::before{
        content: "";
        position: absolute;
        inset: 0;
        border-radius: inherit;
        padding: 1px;
        background: linear-gradient(135deg, rgba(14,165,233,0), rgba(14,165,233,0.5), rgba(34,197,94,0));
        -webkit-mask:
          linear-gradient(#000 0 0) content-box,
          linear-gradient(#000 0 0);
        -webkit-mask-composite: xor;
        mask-composite: exclude;
        opacity: 0;
        transition: opacity .22s ease;
      }
      .mx-fw-card:hover{
        transform: translateY(-4px);
        box-shadow: 0 16px 34px rgba(15,23,42,0.12);
        border-color: rgba(56,189,248,0.7);
        background:
          radial-gradient(circle at 0 0, rgba(56,189,248,0.12) 0, transparent 42%),
          radial-gradient(circle at 100% 100%, rgba(34,197,94,0.10) 0, transparent 42%),
          #ffffff;
      }
      .mx-fw-card:hover::before{
        opacity: 1;
      }

      /* Icon with halo */
      .mx-fw-icon-wrap{
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: .6rem;
        gap: .5rem;
      }
      .mx-fw-icon{
        position: relative;
        width: 38px;
        height: 38px;
        border-radius: .9rem;
        display: flex;
        align-items: center;
        justify-content: center;
        background: radial-gradient(circle at 30% 20%, #e0f2fe 0, #f8fafc 65%);
        color: #0f172a;
        font-size: 1rem;
        overflow: hidden;
        flex-shrink: 0;
      }
      .mx-fw-icon::after{
        content: "";
        position: absolute;
        width: 130%;
        height: 130%;
        background: radial-gradient(circle, rgba(56,189,248,0.30) 0, transparent 60%);
        opacity: 0;
        transform: scale(0.7);
        transition: opacity .26s ease, transform .26s ease;
      }
      .mx-fw-card:hover .mx-fw-icon::after{
        opacity: 1;
        transform: scale(1);
      }

      /* Pill and metric */
      .mx-fw-pill{
        padding: .12rem .55rem;
        font-size: .65rem;
        border-radius: 999px;
        background: #e0f2fe;
        color: #0369a1;
        font-weight: 500;
        white-space: nowrap;
      }
      .mx-fw-metric{
        padding: .12rem .55rem;
        font-size: .65rem;
        border-radius: 999px;
        background: #ecfdf5;
        color: #166534;
        display: inline-flex;
        align-items: center;
        gap: .3rem;
        white-space: nowrap;
      }
      .mx-fw-dot{
        width: .4rem;
        height: .4rem;
        border-radius: 999px;
        background: #22c55e;
      }

      .mx-fw-meta{
        font-size: .75rem;
        color: #6b7280;
        margin-bottom: .1rem;
      }
      .mx-fw-title{
        font-size: .95rem;
        font-weight: 600;
        margin-bottom: .2rem;
        color: #020617;
      }
      .mx-fw-text{
        font-size: .8rem;
        color: #64748b;
        margin-bottom: 0;
      }

      /* reveal hook, works with your existing reveal script */
      .section-featured-grid [data-reveal-group] > *{
        opacity: 0;
        transform: translateY(10px);
      }
      .section-featured-grid [data-reveal-group] > *.in{
        opacity: 1;
        transform: translateY(0);
        transition: opacity .45s ease, transform .45s ease;
      }
    </style>

    <div class="mx-fw-grid" data-reveal-group>

      <!-- Card 1 -->
      <a href="<?= $base ?>/projects.php#covid" class="mx-fw-card">
        <div class="mx-fw-icon-wrap">
          <div class="mx-fw-icon">
            <i class="bi bi-graph-up-arrow"></i>
          </div>
          <div class="d-flex align-items-center gap-1">
            <span class="mx-fw-pill">MoH, GHS</span>
            <span class="mx-fw-metric">
              <span class="mx-fw-dot"></span>
              National dashboards
            </span>
          </div>
        </div>
        <div class="mx-fw-meta">COVID 19 response analytics</div>
        <div class="mx-fw-title">
          COVID 19 dashboard and predictive analysis
        </div>
        <p class="mx-fw-text">
          Situation room dashboard and forecasts that supported national planning and logistics.
        </p>
      </a>

      <!-- Card 2 -->
      <a href="<?= $base ?>/projects.php#chps" class="mx-fw-card">
        <div class="mx-fw-icon-wrap">
          <div class="mx-fw-icon">
            <i class="bi bi-phone"></i>
          </div>
          <div class="d-flex align-items-center gap-1">
            <span class="mx-fw-pill">Primary care</span>
            <span class="mx-fw-metric">
              <span class="mx-fw-dot"></span>
              Community tools
            </span>
          </div>
        </div>
        <div class="mx-fw-meta">CHPS home visits</div>
        <div class="mx-fw-title">
          CHPS home visit app and referral alerts
        </div>
        <p class="mx-fw-text">
          Mobile and web tools for nurses, with structured visits, risk alerts, and stronger follow up.
        </p>
      </a>

      <!-- Card 3 -->
      <a href="<?= $base ?>/projects.php#hhfa" class="mx-fw-card">
        <div class="mx-fw-icon-wrap">
          <div class="mx-fw-icon">
            <i class="bi bi-clipboard-data"></i>
          </div>
          <div class="d-flex align-items-center gap-1">
            <span class="mx-fw-pill">HHFA</span>
            <span class="mx-fw-metric">
              <span class="mx-fw-dot"></span>
              Facility insights
            </span>
          </div>
        </div>
        <div class="mx-fw-meta">Quality of care analytics</div>
        <div class="mx-fw-title">
          HHFA data management and scoring
        </div>
        <p class="mx-fw-text">
          Automated scoring and dashboards to guide investments and benchmark facility readiness.
        </p>
      </a>

    </div>

  </div>
</section>


<!-- BLOG / INSIGHTS -->
<section class="section section-blog" id="blog">
  <div class="container">
    <div class="d-flex justify-content-between align-items-end mb-3 mb-md-4">
      <div>
        <h2 class="h1 m-0 section-title">
          From the <span class="text-primary">Blog</span>
        </h2>
        <p class="small text-muted mb-0">
          Evidence led digital health insights, FHIR first design, and analytics you can use in real programmes.
        </p>
      </div>
      <div class="text-end mt-3 mt-md-0">
        <a href="<?= $base ?>/blog.php" class="btn btn-sm btn-outline-secondary rounded-pill">
          View all articles
        </a>
      </div>
    </div>

    <?php if (!$posts): ?>
      <div class="row">
        <div class="col-12">
          <div class="alert alert-info small mb-0">
            New articles are coming soon. Check back for implementation notes, FHIR patterns, and analytics playbooks.
          </div>
        </div>
      </div>
    <?php else: ?>
      <?php
        $feature = $posts[0];
        $featureThumb = $feature['cover_url'] ?: first_image_src($feature['content'] ?? '');
        $rest = array_slice($posts, 1, 2);
      ?>

      <div class="row g-3 g-lg-4 mx-blog-layout" data-reveal-group>

        <!-- FEATURED ARTICLE -->
        <div class="col-lg-7 d-flex">
          <article class="mx-blog-feature-card h-100 d-flex flex-column flex-fill">

            <?php if ($featureThumb): ?>
              <a
                href="<?= $base ?>/post.php?id=<?= (int)$feature['id'] ?>"
                class="mx-blog-feature-thumb d-block mb-3">
                <div class="mx-blog-thumb-inner">
                  <img
                    src="<?= htmlspecialchars($featureThumb) ?>"
                    alt=""
                    loading="lazy">
                </div>
                <span class="mx-blog-feature-pill">Featured insight</span>
              </a>
            <?php endif; ?>

            <div class="d-flex justify-content-between align-items-center mb-2 mx-blog-topline">
              <span class="mx-blog-label">Implementation note</span>
              <span class="mx-blog-date">
                <?= date('M j, Y', strtotime($feature['created_at'])) ?>
              </span>
            </div>

            <h3 class="h4 mb-2">
              <a
                href="<?= $base ?>/post.php?id=<?= (int)$feature['id'] ?>"
                class="mx-blog-title-link">
                <?= htmlspecialchars($feature['title']) ?>
              </a>
            </h3>

            <?php if (!empty($feature['excerpt'])): ?>
              <p class="mx-blog-excerpt mb-3">
                <?= htmlspecialchars($feature['excerpt']) ?>
              </p>
            <?php endif; ?>

            <div class="mt-auto d-flex justify-content-between align-items-center mx-blog-feature-footer">
              <div class="small text-muted">
                Evidence based, no PHI, field tested
              </div>
              <a
                href="<?= $base ?>/post.php?id=<?= (int)$feature['id'] ?>"
                class="mx-blog-read-link">
                Read article <span>&rarr;</span>
              </a>
            </div>

          </article>
        </div>

        <!-- SIDE STACK: 2 COMPACT ARTICLES -->
        <div class="col-lg-5">
          <div class="d-flex flex-column gap-3 gap-lg-4 mx-blog-mini-stack">

            <?php foreach ($rest as $p):
              $thumb = $p['cover_url'] ?: first_image_src($p['content'] ?? '');
            ?>
              <article class="mx-blog-mini-card d-flex">
                <?php if ($thumb): ?>
                  <a
                    href="<?= $base ?>/post.php?id=<?= (int)$p['id'] ?>"
                    class="mx-blog-mini-thumb me-3">
                    <div class="mx-blog-mini-thumb-inner">
                      <img
                        src="<?= htmlspecialchars($thumb) ?>"
                        alt=""
                        loading="lazy">
                    </div>
                  </a>
                <?php endif; ?>

                <div class="mx-blog-mini-body d-flex flex-column">
                  <div class="d-flex justify-content-between align-items-center mb-1 mx-blog-topline">
                    <span class="mx-blog-label mx-blog-label-soft">Insight</span>
                    <span class="mx-blog-date">
                      <?= date('M j, Y', strtotime($p['created_at'])) ?>
                    </span>
                  </div>

                  <h3 class="h6 mb-1">
                    <a
                      href="<?= $base ?>/post.php?id=<?= (int)$p['id'] ?>"
                      class="mx-blog-title-link mx-blog-title-small">
                      <?= htmlspecialchars($p['title']) ?>
                    </a>
                  </h3>

                  <?php if (!empty($p['excerpt'])): ?>
                    <p class="mx-blog-excerpt mx-blog-excerpt-small mb-2">
                      <?= htmlspecialchars($p['excerpt']) ?>
                    </p>
                  <?php endif; ?>

                  <a
                    href="<?= $base ?>/post.php?id=<?= (int)$p['id'] ?>"
                    class="mx-blog-read-link small mt-auto">
                    Read <span>&rarr;</span>
                  </a>
                </div>
              </article>
            <?php endforeach; ?>

            <?php if (count($rest) === 0): ?>
              <div class="mx-blog-mini-placeholder small text-muted">
                Publish more insights to fill this panel, for example FHIR playbooks, data quality tips, and dashboard notes.
              </div>
            <?php endif; ?>

          </div>
        </div>

      </div> <!-- /row -->
    <?php endif; ?>

  </div>
</section> <!-- end .section-blog -->

<!-- DASHBOARD SNAPSHOT / PROGRAM METRICS -->
<section class="section section-metrics" id="metrics">
  <div class="container">

    <div class="row align-items-center gy-4">
      <!-- Intro text -->
      <div class="col-lg-4">
        <h2 class="h4 mb-2 section-title">Program snapshot</h2>
        <p class="small text-muted mb-3">
          A quick view of how MaColX supports digital health programs with
          production ready data systems and analytics.
        </p>
        <div class="d-flex align-items-center gap-2 small text-muted">
          <span class="metrics-dot-live"></span>
          Live style metrics, illustrative only, no PHI
        </div>
      </div>

      <!-- Metric cards -->
      <div class="col-lg-8">
        <div class="row g-3 mx-metric-grid">

          <div class="col-6 col-md-3">
            <div class="mx-metric-card h-100">
              <div class="mx-metric-label">Health programs</div>
              <div class="mx-metric-number-wrap">
                <span
                  class="mx-metric-number"
                  data-mx-metric
                  data-mxtarget="24"
                  data-mxsuffix="+"
                  data-mxduration="1400"
                >24+</span>
              </div>
              <div class="mx-metric-caption small">
                National and sub national projects supported.
              </div>
            </div>
          </div>

          <div class="col-6 col-md-3">
            <div class="mx-metric-card h-100">
              <div class="mx-metric-label">Facilities</div>
              <div class="mx-metric-number-wrap">
                <span
                  class="mx-metric-number"
                  data-mx-metric
                  data-mxtarget="180"
                  data-mxsuffix="+"
                  data-mxduration="1500"
                >180+</span>
              </div>
              <div class="mx-metric-caption small">
                Sites with digital reporting or dashboards.
              </div>
            </div>
          </div>

          <div class="col-6 col-md-3">
            <div class="mx-metric-card h-100">
              <div class="mx-metric-label">Pipelines</div>
              <div class="mx-metric-number-wrap">
                <span
                  class="mx-metric-number"
                  data-mx-metric
                  data-mxtarget="12"
                  data-mxsuffix="+"
                  data-mxduration="1600"
                >12+</span>
              </div>
              <div class="mx-metric-caption small">
                Automated ETL and analytics workflows in production.
              </div>
            </div>
          </div>

          <div class="col-6 col-md-3">
            <div class="mx-metric-card h-100">
              <div class="mx-metric-label">Uptime</div>
              <div class="mx-metric-number-wrap">
                <span
                  class="mx-metric-number"
                  data-mx-metric
                  data-mxtarget="99.7"
                  data-mxdecimals="1"
                  data-mxsuffix="%"
                  data-mxduration="1700"
                >99.7%</span>
              </div>
              <div class="mx-metric-caption small">
                Typical twelve month platform availability target.
              </div>
            </div>
          </div>

        </div><!-- /.mx-metric-grid -->
      </div>
    </div>

  </div>
</section>

<!-- UPDATES / IMPLEMENTATION NOTES STRIP -->
<section class="section section-updates" id="updates">
  <div class="container">
    <div class="mx-updates-card mx-glass">
      <div class="row align-items-center g-3 g-md-4">
        <!-- Text -->
        <div class="col-md-6">
          <div class="d-flex align-items-center gap-2 mb-2">
            <span class="mx-updates-badge">Updates</span>
            <span class="small text-muted">
              Evidence based, implementation focused, no PHI.
            </span>
          </div>
          <h3 class="h4 mb-2 mb-md-1">
            Get implementation notes on digital health and data systems
          </h3>
          <p class="small text-muted mb-0">
            Occasional short emails on FHIR, DHIS2 integrations, analytics,
            and delivery tips for health programs. Designed for teams in MoH,
            implementers, and technical partners.
          </p>
        </div>

        <!-- Form -->
        <div class="col-md-6">
          <form class="mx-updates-form" action="#" method="post">
            <div class="row g-2 g-sm-3">
              <div class="col-sm-7">
                <label class="visually-hidden" for="updatesEmail">Email</label>
                <input
                  type="email"
                  id="updatesEmail"
                  name="email"
                  class="form-control"
                  placeholder="Work email"
                  required>
              </div>
              <div class="col-sm-5">
                <label class="visually-hidden" for="updatesRole">Role</label>
                <select
                  id="updatesRole"
                  name="role"
                  class="form-select">
                  <option value="">Role optional</option>
                  <option value="moh">MoH or GHS</option>
                  <option value="implementer">Implementer or NGO</option>
                  <option value="hospital">Hospital or facility</option>
                  <option value="data">Data or analytics</option>
                  <option value="dev">Engineering</option>
                </select>
              </div>
              <div class="col-sm-8">
                <div class="form-check mx-updates-check">
                  <input
                    class="form-check-input"
                    type="checkbox"
                    value="1"
                    id="updatesNoPhi"
                    checked>
                  <label class="form-check-label small" for="updatesNoPhi">
                    I understand no patient level data or PHI is shared.
                  </label>
                </div>
              </div>
              <div class="col-sm-4 text-sm-end">
                <button type="submit" class="btn btn-mx w-100 mx-updates-btn">
                  Get notes
                </button>
              </div>
            </div>
          </form>
        </div>

      </div>
    </div>
  </div>
</section>

<!-- CTA -->
<section class="section section-cta">
  <div class="container">
    <div class="cta-box p-4 p-md-5 rounded-4 shadow-sm text-center mx-glass">
      <h2 class="h1 mb-3 section-title">Ready to move your program forward</h2>
      <p class="lead text-muted mb-4">
        Share your goals and a timeline, we will respond with a clear plan and a path to measurable results.
      </p>
      <button class="btn btn-mx btn-lg" data-bs-toggle="modal" data-bs-target="#leadModal">
        Start a project
      </button>
    </div>
  </div>
</section>

<!-- LEAD MODAL -->
<div class="modal fade" id="leadModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content rounded-4">
      <div class="modal-header">
        <h5 class="modal-title">Tell me about your project</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form id="leadForm" class="modal-body">
        <div class="row g-3">
          <div class="col-12">
            <label class="form-label">Full name</label>
            <input type="text" name="full_name" class="form-control" required>
          </div>
          <div class="col-md-6">
            <label class="form-label">Email</label>
            <input type="email" name="email" class="form-control" required>
          </div>
          <div class="col-md-6">
            <label class="form-label">Phone</label>
            <input type="text" name="phone" class="form-control">
          </div>
          <div class="col-md-6">
            <label class="form-label">Organization or program</label>
            <input type="text" name="company" class="form-control">
          </div>
          <div class="col-md-6">
            <label class="form-label">Service</label>
            <input type="text" id="leadService" name="service" class="form-control"
                   placeholder="Digital health, dashboards, training">
          </div>
          <div class="col-12">
            <label class="form-label">Message</label>
            <textarea name="message" rows="4" class="form-control"
                      placeholder="Goals, timeline, and any links"></textarea>
          </div>
          <div class="col-12 small text-muted">
            Your information is private and used only to respond to your request.
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-primary" id="leadSubmitBtn">Send</button>
        </div>
        <div class="alert mt-3 d-none" id="leadAlert"></div>
      </form>
    </div>
  </div>
</div>

<!-- INTERACTIONS -->
<script>
// Prefill service name
document.querySelectorAll('[data-lead-service]').forEach(function(btn){
  btn.addEventListener('click', function(){
    const s = this.getAttribute('data-lead-service');
    const input = document.getElementById('leadService');
    if (input) input.value = s || '';
  });
});

// Handle lead form submission via fetch
const leadForm = document.getElementById('leadForm');
const leadAlert = document.getElementById('leadAlert');
const leadSubmitBtn = document.getElementById('leadSubmitBtn');

if (leadForm) {
  leadForm.addEventListener('submit', async function(e){
    e.preventDefault();
    leadSubmitBtn.disabled = true;
    leadAlert.classList.add('d-none');
    try {
      const formData = new FormData(leadForm);
      const res = await fetch('<?= $base ?>/lead_submit.php', { method: 'POST', body: formData });
      const json = await res.json().catch(()=>({ok:false, error:'Invalid response'}));
      if (res.ok && json.ok) {
        leadAlert.className = 'alert alert-success mt-3';
        leadAlert.textContent = 'Thank you, I will get back to you shortly.';
        leadAlert.classList.remove('d-none');
        leadForm.reset();
      } else {
        throw new Error(json.error || 'Could not send. Try again.');
      }
    } catch (err) {
      leadAlert.className = 'alert alert-danger mt-3';
      leadAlert.textContent = err.message;
      leadAlert.classList.remove('d-none');
    } finally {
      leadSubmitBtn.disabled = false;
    }
  });
}

// Title reveal
(function(){
  const titles = document.querySelectorAll('.section-title');
  const revealNow = el => el.classList.add('reveal-in');

  if (!('IntersectionObserver' in window)) {
    titles.forEach(revealNow);
  } else {
    const tio = new IntersectionObserver((entries)=>{
      entries.forEach((entry)=> {
        if (entry.isIntersecting) {
          revealNow(entry.target);
          tio.unobserve(entry.target);
        }
      });
    }, { threshold: 0.35 });
    titles.forEach(t => tio.observe(t));
  }
})();

// Stagger reveal for groups
(function(){
  const groups = document.querySelectorAll('[data-reveal-group]');
  if (!groups.length) return;

  const io = new IntersectionObserver((entries)=>{
    entries.forEach(entry=>{
      if (!entry.isIntersecting) return;
      const items = Array.from(entry.target.children);
      items.forEach((el, idx)=>{
        el.classList.add('reveal-item');
        setTimeout(()=> el.classList.add('in'), idx * 110);
      });
      io.unobserve(entry.target);
    });
  }, { threshold: 0.18 });

  groups.forEach(g => io.observe(g));
})();

// Metric counter animation
(function(){
  const els = document.querySelectorAll('[data-mx-metric]');
  if (!('IntersectionObserver' in window) || els.length === 0) return;

  const animate = (el) => {
    const target = parseFloat(el.getAttribute('data-mxtarget')) || 0;
    const duration = parseInt(el.getAttribute('data-mxduration'), 10) || 1200;
    const decimals = parseInt(el.getAttribute('data-mxdecimals'), 10) || 0;
    const suffix = el.getAttribute('data-mxsuffix') || '';
    const start = 0;
    const startTime = performance.now();

    const step = (now) => {
      const t = Math.min(1, (now - startTime) / duration);
      const eased = t < 0.5 ? 2*t*t : -1 + (4 - 2*t)*t;
      const value = start + (target - start) * eased;
      el.textContent = value.toFixed(decimals) + suffix;
      if (t < 1) requestAnimationFrame(step);
    };

    requestAnimationFrame(step);
  };

  const io = new IntersectionObserver((entries)=>{
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        animate(entry.target);
        io.unobserve(entry.target);
      }
    });
  }, { threshold: 0.4 });

  els.forEach(el => io.observe(el));
})();

// Sparkline draw effect on view
(function(){
  const cards = document.querySelectorAll('.mx-service-card');
  if (!('IntersectionObserver' in window) || cards.length === 0) return;

  const triggerDraw = (path) => {
    const len = path.getTotalLength ? path.getTotalLength() : 240;
    path.style.transition = 'none';
    path.style.strokeDasharray = len;
    path.style.strokeDashoffset = len;
    void path.offsetWidth; // reflow to reset
    path.style.transition = 'stroke-dashoffset 1.6s ease';
    path.style.strokeDashoffset = 0;
  };

  const io = new IntersectionObserver((entries)=>{
    entries.forEach(entry=>{
      if (!entry.isIntersecting) return;
      entry.target.querySelectorAll('.spark-line').forEach(triggerDraw);
      io.unobserve(entry.target);
    });
  }, { threshold: 0.4 });

  cards.forEach(card => io.observe(card));
})();
</script>
<script>
// Hero parallax, keeps it subtle and performance friendly
(function(){
  const root = document.querySelector('.mx-hero');
  if (!root) return;

  let raf = 0, targetX = 0, targetY = 0;
  const factor = 0.02; // lower is subtler

  function onMove(e){
    const rect = root.getBoundingClientRect();
    const cx = rect.left + rect.width / 2;
    const cy = rect.top + rect.height / 2;
    const x = (e.clientX - cx) / rect.width;
    const y = (e.clientY - cy) / rect.height;
    targetX = x; targetY = y;
    if (!raf) raf = requestAnimationFrame(apply);
  }

  function apply(){
    const imgs = root.querySelectorAll('.slide-img');
    imgs.forEach(img=>{
      img.style.transform = `scale(1.03) translate(${(-targetX*100*factor).toFixed(2)}px, ${(-targetY*100*factor).toFixed(2)}px)`;
    });
    raf = 0;
  }

  // enable on pointer devices only
  const mq = window.matchMedia('(pointer:fine)');
  if (mq.matches){
    root.addEventListener('mousemove', onMove);
  }
})();
</script>


<?php require_once __DIR__ . "/includes/footer.php"; ?>
