<?php
require_once __DIR__ . '/config.php';
header('Content-Type: application/json');

$pdo = db();
if (!$pdo) {
  echo json_encode(['ok' => false, 'error' => 'DB not available']);
  exit;
}

$full_name = trim($_POST['full_name'] ?? '');
$email     = trim($_POST['email'] ?? '');
$phone     = trim($_POST['phone'] ?? '');
$company   = trim($_POST['company'] ?? '');
$service   = trim($_POST['service'] ?? '');
$message   = trim($_POST['message'] ?? '');

if ($full_name === '' || $email === '') {
  echo json_encode(['ok' => false, 'error' => 'Name and email are required']);
  exit;
}

try {
  $stmt = $pdo->prepare("
    INSERT INTO leads(full_name, email, phone, company, service, message, created_at)
    VALUES(:full_name, :email, :phone, :company, :service, :message, NOW())
  ");
  $stmt->execute([
    ':full_name' => $full_name,
    ':email'     => $email,
    ':phone'     => $phone,
    ':company'   => $company,
    ':service'   => $service,
    ':message'   => $message,
  ]);
  echo json_encode(['ok' => true]);
} catch (Throwable $e) {
  echo json_encode(['ok' => false, 'error' => 'Save failed']);
}
