<?php 
$page_title = "Post , MaColX"; 
include __DIR__ . "/includes/header.php"; 
$pdo = db(); 
$id = (int)($_GET['id'] ?? 0);

$post = $prev = $next = null;

if ($pdo && $id) {
  // fetch cover_url too
  $stmt = $pdo->prepare("SELECT id, title, category, content, cover_url, created_at FROM posts WHERE id = ?");
  $stmt->execute([$id]);
  $post = $stmt->fetch();

  if ($post) {
    $stmtPrev = $pdo->prepare("SELECT id, title FROM posts WHERE id < ? ORDER BY id DESC LIMIT 1");
    $stmtPrev->execute([$id]);
    $prev = $stmtPrev->fetch();

    $stmtNext = $pdo->prepare("SELECT id, title FROM posts WHERE id > ? ORDER BY id ASC LIMIT 1");
    $stmtNext->execute([$id]);
    $next = $stmtNext->fetch();
  }
}
?>
<section class="section">
  <div class="container">

    <div class="mb-3">
      <a href="<?php echo $base; ?>/blog.php" class="text-decoration-none">
        <i class="bi bi-arrow-left-circle me-1"></i>Back to blog
      </a>
    </div>

    <?php if(!$post): ?>
      <div class="alert alert-warning shadow-sm">
        <i class="bi bi-exclamation-triangle me-1"></i>Post not found.
      </div>
    <?php else: ?>

      <?php if (!empty($post['cover_url'])): ?>
        <!-- Hero cover -->
        <div class="mb-4">
          <div class="ratio ratio-16x9 rounded shadow-sm overflow-hidden">
            <img src="<?php echo htmlspecialchars($post['cover_url']); ?>" class="w-100 h-100 object-fit-cover" alt="">
          </div>
        </div>
      <?php endif; ?>

      <article>
        <span class="badge bg-primary-subtle text-primary-emphasis mb-2">
          <i class="bi bi-tag me-1"></i><?php echo htmlspecialchars($post['category']); ?>
        </span>
        <h1 class="mb-2">
          <i class="bi bi-file-earmark-text me-1"></i><?php echo htmlspecialchars($post['title']); ?>
        </h1>
        <p class="text-muted">
          <i class="bi bi-calendar-event me-1"></i>
          <?php echo date('M j, Y', strtotime($post['created_at'])); ?>
        </p>

        <!-- Post body -->
        <div class="post-content mt-3">
          <?php echo $post['content']; ?>
        </div>
      </article>

      <hr class="my-5">

      <!-- Prev , next navigation -->
      <div class="row g-2 align-items-center">
        <div class="col-md-4">
          <?php if ($prev): ?>
            <a class="btn btn-outline-secondary w-100 text-start"
               href="<?php echo $base; ?>/post.php?id=<?php echo (int)$prev['id']; ?>">
              <i class="bi bi-arrow-left me-1"></i>Previous  
              <div class="small text-truncate"><?php echo htmlspecialchars($prev['title']); ?></div>
            </a>
          <?php endif; ?>
        </div>

        <div class="col-md-4 text-center">
          <a href="<?php echo $base; ?>/blog.php" class="btn btn-outline-secondary">
            <i class="bi bi-journal-text me-1"></i>All posts
          </a>
          <a href="<?php echo $base; ?>/admin/new_post.php" class="btn btn-primary ms-2">
            <i class="bi bi-pencil-square me-1"></i>New post
          </a>
        </div>

        <div class="col-md-4">
          <?php if ($next): ?>
            <a class="btn btn-outline-secondary w-100 text-end"
               href="<?php echo $base; ?>/post.php?id=<?php echo (int)$next['id']; ?>">
              Next<i class="bi bi-arrow-right ms-1"></i>
              <div class="small text-truncate"><?php echo htmlspecialchars($next['title']); ?></div>
            </a>
          <?php endif; ?>
        </div>
      </div>
    <?php endif; ?>

  </div>
</section>

<!-- Enhance image rendering in content -->
<script>
// add loading lazy to images inside the post body
document.addEventListener('DOMContentLoaded', function () {
  document.querySelectorAll('.post-content img').forEach(function(img){
    if (!img.getAttribute('loading')) img.setAttribute('loading', 'lazy');
    img.classList.add('img-fluid'); // Bootstrap responsive image
  });
});
</script>

<?php include __DIR__ . "/includes/footer.php"; ?>
