<?php 
$page_title = "Projects , MaColX"; 
include __DIR__ . "/includes/header.php"; 

$projects = [
  [
    "id" => "covid",
    "title" => "Ghana COVID 19 dashboard and predictive analysis",
    "category" => "platforms analytics",
    "area" => "National analytics and dashboards",
    "client" => "Ministry of Health and Ghana Health Service",
    "image" => "/assets/projects/covid.jpg",
    "highlight" => "National COVID 19 situation room dashboard with forecasting.",
    "challenge" => "Reporting was fragmented and slow, so national planners did not have a single, trusted view during the COVID 19 response.",
    "contribution" => "Designed and implemented a data pipeline and dashboard that combine routine data, quality checks, and simple forecasts for daily use by national and regional teams.",
    "impact" => "Faster decision cycles, clearer demand signals, and more informed allocation of logistics and human resources.",
    "tech" => "Python, SQL, Power BI, PHP based APIs, secure hosting."
  ],
  [
    "id" => "chps",
    "title" => "CHPS home visit app and referral alerts",
    "category" => "platforms analytics",
    "area" => "Community health and primary care",
    "client" => "Primary care and community health teams",
    "image" => "/assets/projects/chps.png",
    "highlight" => "Mobile and web tools for CHPS home visits, risk alerts, and referrals.",
    "challenge" => "Paper registers slowed follow up and made high risk households difficult to track across CHPS zones.",
    "contribution" => "Delivered a responsive app and web dashboard with offline friendly forms, referral workflows, and supervisory views for subdistrict and district managers.",
    "impact" => "Faster referrals, cleaner visit data, and clearer supervision for community health nurses and officers.",
    "tech" => "PHP, Bootstrap, JavaScript, MySQL, light GIS mapping."
  ],
  [
    "id" => "hhfa",
    "title" => "HHFA data management and quality of care analytics",
    "category" => "analytics research",
    "area" => "Health facility assessment and planning",
    "client" => "Harmonised Health Facility Assessment",
    "image" => "/assets/projects/hhfa.jpg",
    "highlight" => "Converting HHFA survey data into structured scores and dashboards.",
    "challenge" => "Complex survey data from many facilities needed cleaning, scoring, and clear visual outputs for decision makers.",
    "contribution" => "Designed a relational data model and automated quality checks, scoring logic, and reporting views for national and regional teams.",
    "impact" => "Evidence to guide investments, benchmark facilities, and track quality of care trends over time.",
    "tech" => "Python, R, SQL, Power BI."
  ],
  [
    "id" => "predictive-surveillance",
    "title" => "Predictive analytics for disease surveillance in Ghana",
    "category" => "analytics research",
    "area" => "Surveillance and early warning",
    "client" => "Thought leadership and training",
    "image" => "/assets/projects/predictive_surveillance.jpg",
    "highlight" => "Use of routine data for early warning and simple outbreak alerts.",
    "challenge" => "Disease surveillance data arrives slowly and is not structured for early warning alerts.",
    "contribution" => "Showed practical time series and anomaly detection use cases based on routine data and DHIMS2 exports for program teams.",
    "impact" => "Greater interest among programme teams in using predictive models for surveillance and planning.",
    "tech" => "Python, Jupyter, SQL, Power BI."
  ],
  [
    "id" => "genomic-digital-health",
    "title" => "Digital health and genomic data for future care",
    "category" => "analytics research",
    "area" => "Future of personalised medicine",
    "client" => "Thought leadership and policy dialogue",
    "image" => "/assets/projects/genomic_personalised.jpg",
    "highlight" => "Exploring how digital platforms and genomics can enable more personalised care.",
    "challenge" => "Treatment decisions in many African settings do not yet use genomic insights or advanced risk profiling.",
    "contribution" => "Outlined how digital records, genomic data, and AI can work together for risk profiling and individual care plans in resource constrained settings.",
    "impact" => "Strengthened advocacy for investment in genomic and digital health infrastructure and skills.",
    "tech" => "Genomic data platforms, AI models, digital health records."
  ],
  [
    "id" => "paper-to-cloud",
    "title" => "From paper to cloud, integrated health information ecosystems",
    "category" => "platforms analytics",
    "area" => "Health information system architecture",
    "client" => "Health information system teams",
    "image" => "/assets/projects/paper_to_cloud.jpg",
    "highlight" => "Roadmap from paper registers to linked digital systems.",
    "challenge" => "Paper records and siloed systems limited visibility across CHPS, facilities, and national teams.",
    "contribution" => "Outlined architecture, data standards, and API patterns to move data flows into secure and connected digital platforms.",
    "impact" => "Clear roadmaps for stakeholders on how to modernise health information systems over time.",
    "tech" => "PHP, APIs, DHIMS2 integrations, cloud hosting, integration tools."
  ],
  [
    "id" => "big-data-me",
    "title" => "Big data in public health monitoring and evaluation",
    "category" => "analytics research",
    "area" => "Monitoring and evaluation",
    "client" => "Programme and M and E teams",
    "image" => "/assets/projects/big_data_me.jpg",
    "highlight" => "Extending classical monitoring and evaluation with larger data sources.",
    "challenge" => "Many programmes rely only on standard routine indicators and do not use richer data sources.",
    "contribution" => "Introduced data lakes, streaming data, and predictive methods as complements to standard monitoring and evaluation frameworks.",
    "impact" => "Programme teams saw new options for deeper analysis of performance and impact.",
    "tech" => "Python, SQL, data warehouse tools, dashboards."
  ],
  [
    "id" => "ai-radiology",
    "title" => "AI in radiology and laboratory medicine",
    "category" => "analytics research",
    "area" => "Clinical innovation and diagnostics",
    "client" => "Clinical services and teaching",
    "image" => "/assets/projects/ai_radiology.jpg",
    "highlight" => "Safe use of AI to support diagnosis in imaging and laboratory work.",
    "challenge" => "Diagnostic services face heavy workloads and delays, especially in low resource settings.",
    "contribution" => "Showed how AI models can flag abnormal images and patterns in lab results and how to embed them in clinical workflows.",
    "impact" => "Raised awareness of both potential and ethical safeguards for AI in diagnostic pathways.",
    "tech" => "AI vision models, decision support tools, integration with clinical systems."
  ],
];

$total_projects = count($projects);
?>

<style>
.mx-projects-hero-wrap{
  padding-top: 1.5rem;
}
.mx-projects-hero{
  position: relative;
  overflow: hidden;
  border-radius: 1.75rem;
  padding: 2.5rem 1.75rem;
  background: radial-gradient(circle at 0 0, #22c55e 0, rgba(34,197,94,0) 45%),
              radial-gradient(circle at 100% 0, #0ea5e9 0, rgba(14,165,233,0) 50%),
              radial-gradient(circle at 0 100%, #a855f7 0, rgba(168,85,247,0) 55%),
              linear-gradient(135deg, #020617, #020617);
  color: #f9fafb;
  box-shadow: 0 24px 60px rgba(15,23,42,0.7);
  isolation: isolate;
}
.mx-projects-hero::before{
  content: "";
  position: absolute;
  inset: -30%;
  background:
    radial-gradient(120% 120% at 10% 0, rgba(248,250,252,0.1) 0, transparent 50%),
    radial-gradient(140% 140% at 100% 60%, rgba(248,250,252,0.12) 0, transparent 55%);
  mix-blend-mode: screen;
  opacity: 0.9;
  pointer-events: none;
}
.mx-projects-hero-inner{
  position: relative;
  z-index: 2;
}
.mx-hero-particles{
  position: absolute;
  inset: 0;
  overflow: hidden;
  z-index: 1;
  pointer-events: none;
}
.mx-hero-particle{
  position: absolute;
  width: 6px;
  height: 6px;
  border-radius: 999px;
  background: rgba(248,250,252,0.85);
  opacity: 0.7;
  box-shadow: 0 0 12px rgba(248,250,252,0.7);
  animation: mxFloat 12s ease-in-out infinite;
}
.mx-hero-particle:nth-child(1){ top: 14%; left: 10%; animation-duration: 11s; }
.mx-hero-particle:nth-child(2){ top: 30%; left: 80%; animation-duration: 13s; }
.mx-hero-particle:nth-child(3){ top: 65%; left: 20%; animation-duration: 15s; }
.mx-hero-particle:nth-child(4){ top: 75%; left: 65%; animation-duration: 12s; }
.mx-hero-particle:nth-child(5){ top: 40%; left: 45%; animation-duration: 16s; }
.mx-hero-particle:nth-child(6){ top: 18%; left: 60%; animation-duration: 14s; }

@keyframes mxFloat{
  0%   { transform: translate3d(0,0,0) scale(1); opacity: 0.2; }
  25%  { transform: translate3d(12px,-10px,0) scale(1.1); opacity: 0.7; }
  50%  { transform: translate3d(-6px,-18px,0) scale(0.9); opacity: 0.6; }
  75%  { transform: translate3d(8px,8px,0) scale(1.05); opacity: 0.9; }
  100% { transform: translate3d(0,0,0) scale(1); opacity: 0.2; }
}

.mx-projects-kicker{
  font-size: .8rem;
  letter-spacing: .18em;
  text-transform: uppercase;
  color: #a5b4fc;
}
.mx-projects-title{
  font-size: clamp(1.9rem, 3vw, 2.35rem);
}
.mx-projects-sub{
  max-width: 40rem;
}

.mx-projects-stat-pill{
  display: inline-flex;
  align-items: center;
  gap: .35rem;
  padding: .35rem .8rem;
  border-radius: 999px;
  background: rgba(15,23,42,0.85);
  border: 1px solid rgba(148,163,184,0.55);
  font-size: .78rem;
  color: #e5e7eb;
  backdrop-filter: blur(16px);
}
.mx-projects-stat-dot{
  width: .45rem;
  height: .45rem;
  border-radius: 999px;
  background: #22c55e;
  box-shadow: 0 0 0 .18rem rgba(34,197,94,0.4);
}

.mx-project-filters{
  border-radius: 999px;
  padding: .25rem;
  background: rgba(15,23,42,0.04);
  backdrop-filter: blur(12px);
}
.mx-project-filters .btn{
  border: none;
  font-size: .8rem;
}
.mx-project-filters .btn.active{
  background: #0f766e;
  color: #ecfeff;
}

.mx-projects-section{
  padding-top: 2.5rem;
}

/* light cards */
.mx-project-card{
  border: 1px solid rgba(148,163,184,0.25);
  border-radius: 1.25rem;
  background: radial-gradient(circle at 0 0, rgba(56,189,248,0.08) 0, transparent 40%),
              radial-gradient(circle at 100% 100%, rgba(34,197,94,0.08) 0, transparent 45%),
              #ffffff;
  color: #0f172a;
  box-shadow: 0 18px 40px rgba(15,23,42,0.06);
  overflow: hidden;
  transform: translateY(0);
  transition: transform .25s ease, box-shadow .25s ease, border .25s ease;
}
.mx-project-card:hover{
  transform: translateY(-6px);
  box-shadow: 0 26px 60px rgba(15,23,42,0.12);
  border-color: rgba(56,189,248,0.6);
}
.mx-project-thumb{
  border-radius: 1rem;
  overflow: hidden;
}
.mx-project-thumb img{
  transition: transform .45s ease, opacity .45s ease;
  opacity: .98;
}
.mx-project-card:hover .mx-project-thumb img{
  transform: scale(1.05);
  opacity: 1;
}

/* content */
.mx-project-pill{
  display: inline-flex;
  align-items: center;
  padding: .18rem .7rem;
  border-radius: 999px;
  font-size: .65rem;
  letter-spacing: .14em;
  text-transform: uppercase;
  background: rgba(15,23,42,0.03);
  border: 1px solid rgba(148,163,184,0.6);
  color: #0f172a;
}
.mx-project-title{
  font-size: 1rem;
  color: #020617;
}
.mx-project-area{
  font-size: .8rem;
  color: #6b7280;
}
.mx-project-highlight{
  font-size: .8rem;
  color: #111827;
}
.mx-project-meta{
  font-size: .75rem;
  color: #6b7280;
}
.mx-project-impact-badge{
  display: inline-flex;
  align-items: center;
  gap: .3rem;
  padding: .22rem .6rem;
  border-radius: 999px;
  font-size: .72rem;
  background: rgba(22,163,74,0.06);
  color: #166534;
}
.mx-project-impact-dot{
  width: .45rem;
  height: .45rem;
  border-radius: 999px;
  background: #16a34a;
}

/* view details hover effect */
.mx-view-details-btn{
  transition: transform .18s ease, box-shadow .18s ease, background-color .18s ease, color .18s ease;
}
.mx-view-details-btn:hover{
  transform: translateY(-1px);
  box-shadow: 0 10px 25px rgba(15,23,42,0.18);
  background-color: #0f766e;
  color: #ecfeff;
}

/* modal */
.modal.mx-project-modal .modal-content{
  border-radius: 1.5rem;
  border: none;
}
.modal.mx-project-modal .modal-header{
  border-bottom: none;
}
.modal.mx-project-modal .modal-footer{
  border-top: none;
}

/* animation */
.mx-project-card{
  opacity: 0;
  transform: translateY(14px);
}
.mx-project-card.mx-in{
  opacity: 1;
  transform: translateY(0);
  transition: opacity .5s ease, transform .5s ease;
}

@media (prefers-reduced-motion: reduce){
  .mx-projects-hero::before,
  .mx-hero-particle,
  .mx-project-card,
  .mx-project-card:hover,
  .mx-project-thumb img,
  .mx-project-card.mx-in{
    animation: none !important;
    transition: none !important;
    transform: none !important;
  }
}
</style>

<section class="section mx-projects-hero-wrap">
  <div class="container">
    <div class="mx-projects-hero">
      <div class="mx-hero-particles">
        <span class="mx-hero-particle"></span>
        <span class="mx-hero-particle"></span>
        <span class="mx-hero-particle"></span>
        <span class="mx-hero-particle"></span>
        <span class="mx-hero-particle"></span>
        <span class="mx-hero-particle"></span>
      </div>

      <div class="mx-projects-hero-inner">
        <div class="row align-items-center gy-4">
          <div class="col-lg-7">
            <div class="mx-projects-kicker mb-2">
              Selected work , MaColX
            </div>
            <h1 class="mx-projects-title fw-semibold mb-2">
              Digital health and analytics projects with real programme impact
            </h1>
            <p class="mx-projects-sub small mb-3">
              A sample of work across national dashboards, community health tools, and thought leadership, 
              combining engineering, data science, and implementation practice with Ghana Health Service and partners.
            </p>

            <div class="d-flex flex-wrap align-items-center gap-2">
              <span class="mx-projects-stat-pill">
                <span class="mx-projects-stat-dot"></span>
                <span><?= (int)$total_projects ?> projects highlighted</span>
              </span>
              <span class="mx-projects-stat-pill">
                <span class="mx-projects-stat-dot" style="background:#0ea5e9; box-shadow:0 0 0 .18rem rgba(14,165,233,0.4);"></span>
                <span>National and community health work</span>
              </span>
            </div>
          </div>

          <div class="col-lg-5">
            <div class="text-lg-end">
              <div class="mb-3 small text-slate-200">
                Typical collaboration flow
              </div>
              <div class="d-flex flex-lg-column gap-2 justify-content-lg-end">
                <div class="mx-projects-stat-pill">
                  <span>Understand programme questions and context</span>
                </div>
                <div class="mx-projects-stat-pill">
                  <span>Design systems, data flows, and dashboards</span>
                </div>
                <div class="mx-projects-stat-pill">
                  <span>Deliver, document, and support handover</span>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="mt-4 d-flex justify-content-center justify-content-md-start">
          <div class="mx-project-filters d-inline-flex flex-wrap gap-1">
            <button type="button" class="btn btn-sm rounded-pill active" data-project-filter="all">
              All
            </button>
            <button type="button" class="btn btn-sm rounded-pill" data-project-filter="platforms">
              Platforms
            </button>
            <button type="button" class="btn btn-sm rounded-pill" data-project-filter="analytics">
              Analytics and dashboards
            </button>
            <button type="button" class="btn btn-sm rounded-pill" data-project-filter="research">
              Research and insights
            </button>
          </div>
        </div>

      </div>
    </div>
  </div>
</section>

<section class="section mx-projects-section">
  <div class="container">
    <div class="row g-4">
      <?php foreach ($projects as $project): ?>
        <?php
          $cats = htmlspecialchars($project["category"]);
          $id   = htmlspecialchars($project["id"]);
        ?>
        <div class="col-md-6 col-lg-4 d-flex">
          <article
            id="<?= $id; ?>"
            class="mx-case-card card flex-fill mx-project-card"
            data-cats="<?= $cats; ?>">

            <div class="card-body d-flex flex-column">

              <?php if (!empty($project["image"])): ?>
                <div class="ratio ratio-16x9 mb-3 mx-project-thumb">
                  <img
                    src="<?= htmlspecialchars($base . $project["image"]); ?>"
                    class="card-img-top object-fit-cover"
                    alt="<?= htmlspecialchars($project["title"]); ?>">
                </div>
              <?php endif; ?>

              <!-- top row , Platforms , analytics , Real implementation work -->
              <div class="d-flex justify-content-between align-items-center mb-2">
                <span class="mx-project-pill">
                  <?php
                    if (strpos($project["category"], "platforms") !== false && strpos($project["category"], "analytics") !== false) {
                      echo "Platforms , analytics";
                    } elseif (strpos($project["category"], "platforms") !== false) {
                      echo "Platforms";
                    } elseif (strpos($project["category"], "analytics") !== false) {
                      echo "Analytics";
                    } else {
                      echo "Research , insights";
                    }
                  ?>
                </span>
                <span class="mx-project-impact-badge">
                  <span class="mx-project-impact-dot"></span>
                  <span>Real implementation work</span>
                </span>
              </div>

              <!-- then title, area, highlight, client -->
              <h2 class="mx-project-title fw-semibold mb-1">
                <?= htmlspecialchars($project["title"]); ?>
              </h2>

              <div class="mx-project-area mb-1">
                <?= htmlspecialchars($project["area"]); ?>
              </div>

              <p class="mx-project-highlight mb-2">
                <?= htmlspecialchars($project["highlight"]); ?>
              </p>

              <div class="mx-project-meta mb-3">
                Client , <?= htmlspecialchars($project["client"]); ?>
              </div>

              <div class="mt-auto d-flex justify-content-between align-items-center">
                <button
                  class="btn btn-sm btn-light rounded-pill px-3 mx-view-details-btn"
                  type="button"
                  data-bs-toggle="modal"
                  data-bs-target="#projectModal<?= $id; ?>">
                  View details
                </button>
              </div>
            </div>
          </article>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<?php foreach ($projects as $project): ?>
  <?php
    $id = htmlspecialchars($project["id"]);
  ?>
  <div
    class="modal fade mx-project-modal"
    id="projectModal<?= $id; ?>"
    tabindex="-1"
    aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">
            <?= htmlspecialchars($project["title"]); ?>
          </h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <div class="row g-3">
            <div class="col-md-7">
              <p class="small text-muted mb-1">
                <strong>Client</strong>, <?= htmlspecialchars($project["client"]); ?>
              </p>
              <p class="small text-muted mb-1">
                <strong>Focus area</strong>, <?= htmlspecialchars($project["area"]); ?>
              </p>

              <p class="small mt-3 mb-2">
                <strong>Challenge</strong>
              </p>
              <p class="small text-muted mb-2">
                <?= htmlspecialchars($project["challenge"]); ?>
              </p>

              <p class="small mt-3 mb-2">
                <strong>Contribution</strong>
              </p>
              <p class="small text-muted mb-2">
                <?= htmlspecialchars($project["contribution"]); ?>
              </p>

              <p class="small mt-3 mb-2">
                <strong>Impact</strong>
              </p>
              <p class="small text-muted mb-2">
                <?= htmlspecialchars($project["impact"]); ?>
              </p>

              <p class="small mt-3 mb-0">
                <strong>Technology used</strong><br>
                <span class="text-muted">
                  <?= htmlspecialchars($project["tech"]); ?>
                </span>
              </p>
            </div>

            <div class="col-md-5">
              <?php if (!empty($project["image"])): ?>
                <div class="ratio ratio-4x3 mb-3 rounded-3 overflow-hidden">
                  <img
                    src="<?= htmlspecialchars($base . $project["image"]); ?>"
                    class="w-100 h-100 object-fit-cover"
                    alt="<?= htmlspecialchars($project["title"]); ?>">
                </div>
              <?php endif; ?>
              <div class="small text-muted">
                Each project is delivered with programme teams and technical partners, 
                with emphasis on documentation, capacity, and long term maintainability.
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button
            type="button"
            class="btn btn-outline-secondary btn-sm"
            data-bs-dismiss="modal">
            Close
          </button>
        </div>
      </div>
    </div>
  </div>
<?php endforeach; ?>

<script>
(function(){
  const buttons = document.querySelectorAll("[data-project-filter]");
  const cards   = document.querySelectorAll(".mx-project-card");
  if (!buttons.length || !cards.length) return;

  buttons.forEach(btn => {
    btn.addEventListener("click", () => {
      const tag = btn.getAttribute("data-project-filter");

      buttons.forEach(b => b.classList.remove("active"));
      btn.classList.add("active");

      cards.forEach(card => {
        const cats = (card.getAttribute("data-cats") || "").split(/\s+/);
        if (tag === "all") {
          card.classList.remove("d-none");
        } else {
          const match =
            (tag === "platforms" && cats.includes("platforms")) ||
            (tag === "analytics" && cats.includes("analytics")) ||
            (tag === "research" && cats.includes("research"));
          if (match) {
            card.classList.remove("d-none");
          } else {
            card.classList.add("d-none");
          }
        }
      });
    });
  });
})();

(function(){
  const cards = document.querySelectorAll(".mx-project-card");
  if (!("IntersectionObserver" in window) || !cards.length) {
    cards.forEach(c => c.classList.add("mx-in"));
    return;
  }

  const io = new IntersectionObserver(entries => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        entry.target.classList.add("mx-in");
        io.unobserve(entry.target);
      }
    });
  }, { threshold: 0.15 });

  cards.forEach(card => io.observe(card));
})();
</script>

<?php include __DIR__ . "/includes/footer.php"; ?>
