<?php 
$page_title = "Research — MaColX"; 
include __DIR__ . "/includes/header.php"; 
?>

<!-- Research Hero -->
<section class="section section-services text-center text-md-start">
  <div class="container">
    <div class="row g-4 align-items-center">
      <div class="col-lg-6 order-2 order-lg-1">
        <span class="mx-role-chip mb-2">Applied Digital Health Research</span>
        <h1 class="h1 mb-2 section-title">Research &amp; Evidence for Real Health Systems</h1>
        <p class="lead text-muted mb-3">
          We work with ministries, programs, and partners to design and evaluate digital health
          interventions that actually work in the field — from CHPS compounds to national dashboards.
        </p>
        <p class="small text-muted mb-4">
          Our work is aligned with <strong>WHO Digital Health Guidelines</strong>,
          <strong>ICD-10/ICD-11</strong>, <strong>HL7 FHIR</strong>, and national
          eHealth strategies to ensure safe, ethical, and scalable impact.
        </p>
        <div class="d-flex flex-wrap gap-2">
          <a href="<?= $base ?>/contact.php" class="btn btn-mx btn-lg">
            Start a research partnership
          </a>
          <a href="<?= $base ?>/services.php" class="btn btn-ghost">
            Explore our services
          </a>
        </div>
      </div>

      <div class="col-lg-6 order-1 order-lg-2 text-center">
        <div class="mx-glass img-rounded img-shadow p-2 d-inline-block">
          <img
            src="<?= $base ?>/assets/img/ghs_digital_health.jpg"
            alt="Ghana Health Service digital health research"
            class="img-fluid img-rounded object-fit-cover"
          >
        </div>
        <p class="small text-muted mt-2 mb-0">
          Field research with Ghana Health Service CHPS workers on community reporting and digital tools.
        </p>
      </div>
    </div>
  </div>
</section>

<!-- Flagship Study: CHPS -->
<section class="section section-tight">
  <div class="container">
    <div class="mx-glass p-4 p-md-5 rounded-4">
      <div class="row g-4 align-items-center">
        <div class="col-md-8">
          <h2 class="h5 mb-2 section-title">Flagship Study: Community Health Reporting under CHPS</h2>
          <p class="small mb-2">
            <strong>Main objective:</strong> Evaluate the current community health reporting system
            under the Community-based Health Planning and Services (CHPS) programme in Ghana,
            with a particular focus on the reporting of home visits.
          </p>
          <p class="small text-muted mb-0">
            The study recommends adopting a <strong>digital mobile–web platform</strong> to improve
            data quality, timeliness, and use of information for decision-making at all levels of the
            health system.
          </p>
        </div>
        <div class="col-md-4">
          <div class="alert alert-success shadow-sm small mb-0" role="alert">
            <strong>UHC alignment:</strong> This research supports Ghana’s Universal Health Coverage (UHC)
            agenda by improving real-time data use, community-level decision-making, and digital health
            integration.
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Research Metrics (with count-up) -->
<section class="section section-metrics">
  <div class="container">
    <div class="d-flex justify-content-between align-items-center mb-3">
      <h2 class="h5 mb-0 section-title">Research in numbers</h2>
      <div class="d-flex align-items-center gap-2 small text-muted">
        <span class="metrics-dot-live"></span>
        Live program metrics (illustrative, updated as projects scale)
      </div>
    </div>

    <div class="row g-3 mx-metric-grid">
      <div class="col-md-4">
        <div class="mx-metric-card h-100">
          <div class="mx-metric-label">Countries engaged</div>
          <div class="mx-metric-number-wrap">
            <div class="mx-metric-number">
              <span class="research-metric" data-target="3">0</span>+
            </div>
          </div>
          <div class="mx-metric-caption small">
            Applied research collaborations with ministries and implementing partners in Africa.
          </div>
        </div>
      </div>

      <div class="col-md-4">
        <div class="mx-metric-card h-100">
          <div class="mx-metric-label">Studies &amp; pilots</div>
          <div class="mx-metric-number-wrap">
            <div class="mx-metric-number">
              <span class="research-metric" data-target="8">0</span>+
            </div>
          </div>
          <div class="mx-metric-caption small">
            Digital health evaluations, implementation studies, and analytics pilots.
          </div>
        </div>
      </div>

      <div class="col-md-4">
        <div class="mx-metric-card h-100">
          <div class="mx-metric-label">Data points analysed</div>
          <div class="mx-metric-number-wrap">
            <div class="mx-metric-number">
              <span class="research-metric" data-target="250000">0</span>+
            </div>
          </div>
          <div class="mx-metric-caption small">
            Routine service data, community visit logs, and survey records powering insights.
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Focus Areas with Filter Chips -->
<section class="section section-alt">
  <div class="container">
    <div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
      <div>
        <h2 class="h5 mb-1 section-title">Research focus areas</h2>
        <p class="small text-muted mb-0">
          Filter by theme to see how our work supports safer, more effective digital health programs.
        </p>
      </div>
      <div class="d-flex flex-wrap gap-2">
        <button type="button"
                class="btn btn-sm btn-outline-secondary research-filter-chip active"
                data-filter="all">
          All
        </button>
        <button type="button"
                class="btn btn-sm btn-outline-secondary research-filter-chip"
                data-filter="community">
          Community data
        </button>
        <button type="button"
                class="btn btn-sm btn-outline-secondary research-filter-chip"
                data-filter="ai">
          AI &amp; predictive analytics
        </button>
        <button type="button"
                class="btn btn-sm btn-outline-secondary research-filter-chip"
                data-filter="interop">
          Interoperability
        </button>
        <button type="button"
                class="btn btn-sm btn-outline-secondary research-filter-chip"
                data-filter="governance">
          Governance &amp; ethics
        </button>
      </div>
    </div>

    <div class="row g-4">

      <!-- Community + AI -->
      <div class="col-md-6 col-lg-4 research-card-wrap" data-tags="community ai">
        <a href="javascript:void(0)" class="mx-case-card h-100">
          <div class="mx-case-topline">
            <span class="mx-case-label">CHPS / mHealth</span>
            <span class="mx-case-metric">
              <span class="mx-pulse-dot"></span>
              Active pilot
            </span>
          </div>
          <h3><span>Digitizing Community Health Monitoring &amp; Intelligence</span></h3>
          <p class="mx-case-desc">
            Co-designing an mHealth platform for CHPS home visits, with early-warning signals
            for household and population-level risks.
          </p>
          <div class="mx-case-badges">
            <span class="mx-badge-tech">Community case management</span>
            <span class="mx-badge-tech">Offline-first data capture</span>
            <span class="mx-badge-tech">Dashboards for supervisors</span>
          </div>
        </a>
      </div>

      <!-- AI & outcomes -->
      <div class="col-md-6 col-lg-4 research-card-wrap" data-tags="ai interop">
        <a href="javascript:void(0)" class="mx-case-card h-100">
          <div class="mx-case-topline">
            <span class="mx-case-label">AI &amp; Outcomes</span>
            <span class="mx-case-metric">
              <span class="mx-pulse-dot"></span>
              Model development
            </span>
          </div>
          <h3><span>Machine Learning for Disease Progression &amp; Outcomes</span></h3>
          <p class="mx-case-desc">
            Building data-driven models to predict clinical trajectories and optimize interventions,
            with a strong focus on fairness and explainability.
          </p>
          <div class="mx-case-badges">
            <span class="mx-badge-tech">Python / R modelling</span>
            <span class="mx-badge-tech">Explainable AI</span>
            <span class="mx-badge-tech">Clinician feedback loops</span>
          </div>
        </a>
      </div>

      <!-- Interoperability -->
      <div class="col-md-6 col-lg-4 research-card-wrap" data-tags="interop governance">
        <a href="javascript:void(0)" class="mx-case-card h-100">
          <div class="mx-case-topline">
            <span class="mx-case-label">Interoperability</span>
            <span class="mx-case-metric">
              <span class="mx-pulse-dot"></span>
              Standards-driven
            </span>
          </div>
          <h3><span>Architectures Connecting EMRs, CHIS &amp; DHIS2</span></h3>
          <p class="mx-case-desc">
            Studying how HL7 FHIR, ICD-10/11, and open standards can connect point-of-care systems
            with national reporting platforms.
          </p>
          <div class="mx-case-badges">
            <span class="mx-badge-tech">HL7 FHIR</span>
            <span class="mx-badge-tech">ICD-10/ICD-11</span>
            <span class="mx-badge-tech">DHIS2 integration</span>
          </div>
        </a>
      </div>

      <!-- Governance -->
      <div class="col-md-6 col-lg-4 research-card-wrap" data-tags="governance">
        <a href="javascript:void(0)" class="mx-case-card h-100">
          <div class="mx-case-topline">
            <span class="mx-case-label">Governance</span>
            <span class="mx-case-metric">
              <span class="mx-pulse-dot"></span>
              Policy-facing
            </span>
          </div>
          <h3><span>Data Governance, Privacy &amp; Responsible AI</span></h3>
          <p class="mx-case-desc">
            Developing practical frameworks for consent, role-based access, de-identification,
            and ethical AI in digital health systems.
          </p>
          <div class="mx-case-badges">
            <span class="mx-badge-tech">Data protection by design</span>
            <span class="mx-badge-tech">Responsible AI</span>
            <span class="mx-badge-tech">Ethics review support</span>
          </div>
        </a>
      </div>

      <!-- Implementation research -->
      <div class="col-md-6 col-lg-4 research-card-wrap" data-tags="community governance">
        <a href="javascript:void(0)" class="mx-case-card h-100">
          <div class="mx-case-topline">
            <span class="mx-case-label">Implementation Science</span>
            <span class="mx-case-metric">
              <span class="mx-pulse-dot"></span>
              Mixed-methods
            </span>
          </div>
          <h3><span>Implementation Research for UHC &amp; Digital M&amp;E</span></h3>
          <p class="mx-case-desc">
            Evaluating how digital tools change workload, equity, and decision-making — and what it
            takes for interventions to scale sustainably.
          </p>
          <div class="mx-case-badges">
            <span class="mx-badge-tech">Health worker interviews</span>
            <span class="mx-badge-tech">Routine indicators</span>
            <span class="mx-badge-tech">UHC impact framing</span>
          </div>
        </a>
      </div>

      <!-- Future collaborations -->
      <div class="col-md-6 col-lg-4 research-card-wrap" data-tags="community ai interop governance">
        <a href="<?= $base ?>/contact.php" class="mx-case-card h-100">
          <div class="mx-case-topline">
            <span class="mx-case-label">Partnerships</span>
            <span class="mx-case-metric">
              <span class="mx-pulse-dot"></span>
              Open call
            </span>
          </div>
          <h3><span>New Collaborative Studies</span></h3>
          <p class="mx-case-desc">
            Co-designing multi-country and single-country studies with ministries, implementers,
            and academic partners — from protocol through to policy briefs.
          </p>
          <div class="mx-case-badges">
            <span class="mx-badge-tech">Protocols &amp; ethics</span>
            <span class="mx-badge-tech">Operational research</span>
            <span class="mx-badge-tech">Dissemination &amp; policy</span>
          </div>
        </a>
      </div>

    </div>
  </div>
</section>

<!-- From Data to Policy Pipeline -->
<section class="section section-pipeline text-center">
  <div class="container">
    <h2 class="h5 mb-3 section-title">From field data to policy decisions</h2>
    <p class="small text-muted mb-4">
      We treat research as a continuous pipeline — from co-design with health workers to dashboards
      and policy briefs used in national review meetings.
    </p>
    <div class="pipeline-wrapper d-flex flex-wrap justify-content-center align-items-center gap-3">
      <div class="pipeline-step pipeline-node active">
        <i class="bi bi-people"></i> Co-design &amp; protocols
      </div>
      <div class="pipeline-arrow"></div>
      <div class="pipeline-step pipeline-node">
        <i class="bi bi-clipboard-check"></i> Instruments &amp; pilots
      </div>
      <div class="pipeline-arrow"></div>
      <div class="pipeline-step pipeline-node">
        <i class="bi bi-phone"></i> Digital data capture
      </div>
      <div class="pipeline-arrow"></div>
      <div class="pipeline-step pipeline-node">
        <i class="bi bi-bar-chart-line"></i> Analysis &amp; modelling
      </div>
      <div class="pipeline-arrow"></div>
      <div class="pipeline-step pipeline-node">
        <i class="bi bi-building"></i> Policy &amp; scale-up
      </div>
    </div>
  </div>
</section>

<!-- Ethics & Standards -->
<section class="section section-standards text-center">
  <div class="container">
    <div class="mx-glass p-4 p-md-5 rounded-4 shadow-sm">
      <p class="small text-muted mb-1">
        All studies follow <strong>ethical review</strong> processes, local regulatory requirements,
        and <strong>WHO digital health guidance</strong> on safety, security, and equity.
      </p>
      <p class="small text-muted mb-0">
        We design consent flows, governance structures, and data pipelines so that
        <strong>patients, communities, and health workers are protected</strong> while still enabling
        strong evidence for decision-making.
      </p>
    </div>
  </div>
</section>

<!-- CTA -->
<section class="section text-center">
  <div class="container">
    <div class="cta-box p-4 p-md-5 rounded-4 shadow-sm mx-glass">
      <h2 class="h4 mb-2 section-title">Let’s build evidence together.</h2>
      <p class="small text-muted mb-4">
        Whether you are piloting a new digital tool or scaling national systems, we can help design,
        evaluate, and translate evidence into action for ministries and partners.
      </p>
      <a href="<?= $base ?>/contact.php" class="btn btn-mx btn-lg">
        Start a research project
      </a>
    </div>
  </div>
</section>

<!-- Page-specific JS for metrics + filters -->
<script>
document.addEventListener('DOMContentLoaded', function () {
  // ---- Metric count-up ----
  var metricEls = document.querySelectorAll('.research-metric');
  var metricsStarted = false;

  function startMetrics() {
    if (metricsStarted) return;
    metricsStarted = true;

    metricEls.forEach(function (el) {
      var target = parseInt(el.getAttribute('data-target'), 10);
      if (isNaN(target)) return;

      var duration = 1200; // ms
      var start = 0;
      var startTime = null;

      function step(timestamp) {
        if (!startTime) startTime = timestamp;
        var progress = Math.min((timestamp - startTime) / duration, 1);
        var value = Math.floor(progress * target);
        el.textContent = value.toLocaleString();
        if (progress < 1) {
          window.requestAnimationFrame(step);
        } else {
          el.textContent = target.toLocaleString();
        }
      }

      window.requestAnimationFrame(step);
    });
  }

  var metricsSection = document.querySelector('.section-metrics');
  if ('IntersectionObserver' in window && metricsSection) {
    var io = new IntersectionObserver(function (entries) {
      entries.forEach(function (entry) {
        if (entry.isIntersecting) {
          startMetrics();
          io.disconnect();
        }
      });
    }, { threshold: 0.3 });
    io.observe(metricsSection);
  } else {
    // Fallback: start after small delay
    setTimeout(startMetrics, 800);
  }

  // ---- Research focus filter chips ----
  var chips = document.querySelectorAll('.research-filter-chip');
  var cards = document.querySelectorAll('.research-card-wrap');

  chips.forEach(function (chip) {
    chip.addEventListener('click', function () {
      var filter = chip.getAttribute('data-filter');
      chips.forEach(function (c) { c.classList.remove('active'); });
      chip.classList.add('active');

      cards.forEach(function (card) {
        var tags = (card.getAttribute('data-tags') || '').split(/\s+/);
        if (filter === 'all' || tags.indexOf(filter) !== -1) {
          card.classList.remove('d-none');
        } else {
          card.classList.add('d-none');
        }
      });
    });
  });

  // ---- Pipeline hover highlight ----
  var pipelineNodes = document.querySelectorAll('.pipeline-node');
  pipelineNodes.forEach(function (node) {
    node.addEventListener('mouseenter', function () {
      pipelineNodes.forEach(function (n) { n.classList.remove('active'); });
      node.classList.add('active');
    });
  });
});
</script>

<?php include __DIR__ . "/includes/footer.php"; ?>
