<?php 
$page_title = "Services , MaColX";
include __DIR__ . "/includes/header.php";
?>

<style>
  /* Hero background reuse if needed */
  .section-services{
    background:
      radial-gradient(circle at 0 0, rgba(56,189,248,0.16) 0, transparent 50%),
      radial-gradient(circle at 100% 0, rgba(34,197,94,0.16) 0, transparent 55%),
      linear-gradient(135deg, #f8fafc, #eef2ff);
  }

  /* New rich background for the 8 card block */
  .section-services-main{
    position: relative;
    padding-top: 2.5rem;
    padding-bottom: 3rem;
  }
  .section-services-main::before{
    content: "";
    position: absolute;
    inset: 0;
    background:
      radial-gradient(circle at 10% 0, rgba(56,189,248,0.18) 0, transparent 55%),
      radial-gradient(circle at 80% 100%, rgba(129,140,248,0.16) 0, transparent 55%),
      radial-gradient(circle at 0 100%, rgba(34,197,94,0.14) 0, transparent 50%);
    opacity: .9;
    pointer-events: none;
  }
  .section-services-main::after{
    content: "";
    position: absolute;
    inset: 15% 8%;
    background-image: linear-gradient(
      120deg,
      rgba(148,163,184,0.16) 1px,
      transparent 1px
    );
    background-size: 28px 28px;
    opacity: .35;
    mix-blend-mode: soft-light;
    pointer-events: none;
  }
  .mx-services-shell{
    position: relative;
    z-index: 2;
  }

  /* Header row inside services main */
  .mx-services-header{
    display: flex;
    flex-direction: column;
    gap: .6rem;
    margin-bottom: 1.5rem;
  }
  @media (min-width: 768px){
    .mx-services-header{
      flex-direction: row;
      justify-content: space-between;
      align-items: flex-end;
      margin-bottom: 1.8rem;
    }
  }
  .mx-services-kicker{
    display: inline-flex;
    align-items: center;
    gap: .4rem;
    padding: .25rem .8rem;
    border-radius: 999px;
    background: rgba(15,23,42,0.9);
    color: #e5e7eb;
    font-size: .78rem;
    letter-spacing: .16em;
    text-transform: uppercase;
  }
  .mx-services-kicker-dot{
    width: .45rem;
    height: .45rem;
    border-radius: 999px;
    background: #22c55e;
    box-shadow: 0 0 0 .18rem rgba(34,197,94,0.45);
  }
  .mx-services-subtitle{
    max-width: 30rem;
    font-size: .84rem;
  }
  .mx-services-pill-row{
    display: flex;
    flex-wrap: wrap;
    gap: .5rem;
    justify-content: flex-start;
  }
  .mx-services-pill{
    font-size: .78rem;
    padding: .25rem .75rem;
    border-radius: 999px;
    border: 1px solid rgba(148,163,184,0.5);
    background: rgba(15,23,42,0.03);
    color: #4b5563;
    backdrop-filter: blur(8px);
  }

  /* Card grid enhancements */
  .mx-service-grid-outer{
    border-radius: 1.75rem;
    padding: 1.6rem 1.4rem 1.7rem;
    background: rgba(248,250,252,0.95);
    box-shadow:
      0 18px 40px rgba(15,23,42,0.12),
      0 0 0 1px rgba(148,163,184,0.28);
    backdrop-filter: blur(14px);
  }

  .mx-service-card{
    position: relative;
    border-radius: 1.3rem;
    border: 1px solid rgba(148,163,184,0.35);
    background:
      radial-gradient(circle at 0 0, rgba(56,189,248,0.10) 0, transparent 55%),
      radial-gradient(circle at 100% 100%, rgba(34,197,94,0.09) 0, transparent 55%),
      #ffffff;
    box-shadow: 0 14px 28px rgba(15,23,42,0.08);
    overflow: hidden;
    transition: transform .22s ease, box-shadow .22s ease, border-color .22s ease;
  }
  .mx-service-card::before{
    content: "";
    position: absolute;
    inset: 0;
    background: radial-gradient(circle at 0 0, rgba(248,250,252,0.45) 0, transparent 55%);
    opacity: 0;
    pointer-events: none;
    transition: opacity .25s ease;
  }
  .mx-service-card:hover{
    transform: translateY(-6px);
    box-shadow: 0 22px 50px rgba(15,23,42,0.18);
    border-color: rgba(56,189,248,0.9);
  }
  .mx-service-card:hover::before{
    opacity: 1;
  }

  .mx-service-card .mx-service-icon{
    width: 2.4rem;
    height: 2.4rem;
    border-radius: .9rem;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #0ea5e9, #22c55e);
    color: #ecfeff;
    box-shadow: 0 10px 20px rgba(14,165,233,0.55);
    font-size: 1.1rem;
  }
  .mx-service-title-wrap{
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    gap: .5rem;
  }
  .mx-service-mini-tag{
    font-size: .7rem;
    text-transform: uppercase;
    letter-spacing: .16em;
    color: #64748b;
  }

  .mx-service-metric{
    padding-top: .5rem;
    border-top: 1px dashed rgba(148,163,184,0.6);
    display: flex;
    justify-content: space-between;
    align-items: flex-end;
    gap: .5rem;
  }
  .mx-service-label{
    font-size: .72rem;
    text-transform: uppercase;
    letter-spacing: .12em;
  }
  .mx-service-metric .small.fw-semibold{
    font-size: .78rem;
  }

  /* Sparklines , reusing your motion idea */
  .mx-service-spark svg{
    width: 90px;
    height: 26px;
    display: block;
  }
  .spark-line,
  .spark-bar,
  .spark-area{
    stroke-width: 1.8;
    fill: none;
  }
  .spark-line-1{ stroke: #0ea5e9; }
  .spark-line-2{ stroke: #22c55e; }
  .spark-line-3{ stroke: #a855f7; }
  .spark-line-4{ stroke: #f97316; }
  .spark-line-5{ stroke: #6366f1; }

  .spark-bar{
    fill: rgba(56,189,248,0.85);
  }

  .spark-area{
    fill: rgba(34,197,94,0.18);
  }

  .spark-grid{
    stroke: rgba(148,163,184,0.4);
    stroke-width: 1;
  }

  @media (max-width: 767.98px){
    .mx-service-grid-outer{
      padding: 1.2rem 1rem 1.3rem;
      border-radius: 1.3rem;
    }
  }
</style>

<!-- Hero / Intro -->
<section class="section section-services text-center text-md-start">
  <div class="container">
    <div class="row align-items-center g-4">
      <div class="col-lg-6">
        <h1 class="h1 mb-2 section-title">Our core services</h1>
        <p class="lead text-muted mb-3">
          We support ministries, health programmes, and partners to build secure, interoperable,
          and analytics driven systems so that data can support real time decisions.
        </p>
        <a href="<?= $base ?>/contact.php" class="btn btn-mx btn-lg">Request consultation</a>
      </div>
      <div class="col-lg-6 text-center">
        <div class="services-hero-graphic mx-auto">
          <img src="<?= $base ?>/assets/img/services_graphic.svg"
               alt="Digital health services"
               class="img-fluid img-rounded img-shadow">
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Services Cards , rich background and 8 cards -->
<section class="section section-services-main">
  <div class="container mx-services-shell">

    <!-- header strip inside services section -->
    <div class="mx-services-header">
      <div>
        <div class="mx-services-kicker mb-2">
          <span class="mx-services-kicker-dot"></span>
          <span>Health and information technology services</span>
        </div>
        <p class="mx-services-subtitle text-muted mb-0">
          A connected set of services across digital health, data science,
          monitoring and evaluation, software engineering, and delivery.
        </p>
      </div>
      <div class="mx-services-pill-row">
        <span class="mx-services-pill">Digital health platforms</span>
        <span class="mx-services-pill">Analytics and dashboards</span>
        <span class="mx-services-pill">Monitoring and evaluation</span>
        <span class="mx-services-pill">Capacity building</span>
      </div>
    </div>

    <div class="mx-service-grid-outer">
      <div class="row g-4">

        <!-- 1. Digital health systems development -->
        <div class="col-md-6 col-lg-3">
          <div class="mx-service-card h-100 p-3 mx-card-hover">
            <div class="d-flex align-items-start gap-2 mb-2">
              <div class="mx-service-icon">
                <i class="bi bi-activity"></i>
              </div>
              <div class="mx-service-title-wrap">
                <div>
                  <div class="mx-service-mini-tag">Systems</div>
                  <h3 class="h6 mt-1 mb-0">Digital health systems development</h3>
                </div>
              </div>
            </div>
            <p class="small text-muted mb-3">
              Building practical digital health solutions that work in real clinics, communities,
              and national programmes.
            </p>
            <div class="mx-service-metric">
              <div>
                <div class="mx-service-label text-muted">System uptime</div>
                <div class="small fw-semibold">High availability</div>
              </div>
              <div class="mx-service-spark">
                <svg viewBox="0 0 100 24" preserveAspectRatio="none" aria-hidden="true">
                  <path class="spark-grid" d="M0 18 H100" />
                  <path d="M0,18 L20,16 L40,15 L60,13 L80,12 L100,11"
                        class="spark-line spark-line-1"></path>
                </svg>
              </div>
            </div>
          </div>
        </div>

        <!-- 2. Biomedical and health data science -->
        <div class="col-md-6 col-lg-3">
          <div class="mx-service-card h-100 p-3 mx-card-hover">
            <div class="d-flex align-items-start gap-2 mb-2">
              <div class="mx-service-icon">
                <i class="bi bi-cpu"></i>
              </div>
              <div class="mx-service-title-wrap">
                <div>
                  <div class="mx-service-mini-tag">Models</div>
                  <h3 class="h6 mt-1 mb-0">Biomedical and health data science</h3>
                </div>
              </div>
            </div>
            <p class="small text-muted mb-3">
              Using advanced analytics and modelling to turn routine health data into meaningful
              insights for clinical and public health action.
            </p>
            <div class="mx-service-metric">
              <div>
                <div class="mx-service-label text-muted">Model stability</div>
                <div class="small fw-semibold">Consistent performance</div>
              </div>
              <div class="mx-service-spark">
                <svg viewBox="0 0 100 24" preserveAspectRatio="none" aria-hidden="true">
                  <path class="spark-grid" d="M0 18 H100" />
                  <rect x="5"  y="11" width="6" height="13" class="spark-bar"></rect>
                  <rect x="20" y="13" width="6" height="11" class="spark-bar"></rect>
                  <rect x="35" y="9"  width="6" height="15" class="spark-bar"></rect>
                  <rect x="50" y="11" width="6" height="13" class="spark-bar"></rect>
                  <rect x="65" y="8"  width="6" height="16" class="spark-bar"></rect>
                  <rect x="80" y="7"  width="6" height="17" class="spark-bar"></rect>
                </svg>
              </div>
            </div>
          </div>
        </div>

        <!-- 3. Research, evidence and analytics -->
        <div class="col-md-6 col-lg-3">
          <div class="mx-service-card h-100 p-3 mx-card-hover">
            <div class="d-flex align-items-start gap-2 mb-2">
              <div class="mx-service-icon">
                <i class="bi bi-journal-text"></i>
              </div>
              <div class="mx-service-title-wrap">
                <div>
                  <div class="mx-service-mini-tag">Evidence</div>
                  <h3 class="h6 mt-1 mb-0">Research, evidence and analytics</h3>
                </div>
              </div>
            </div>
            <p class="small text-muted mb-3">
              Designing studies, analysing health and programme data, and producing clear evidence
              that supports decision making.
            </p>
            <div class="mx-service-metric">
              <div>
                <div class="mx-service-label text-muted">Timely outputs</div>
                <div class="small fw-semibold">Structured delivery</div>
              </div>
              <div class="mx-service-spark">
                <svg viewBox="0 0 100 24" preserveAspectRatio="none" aria-hidden="true">
                  <path class="spark-grid" d="M0 16 H100" />
                  <polyline class="spark-line spark-line-2"
                            points="0,16 14,16 22,10 30,17 44,8 58,17 70,12 84,18 100,14" />
                </svg>
              </div>
            </div>
          </div>
        </div>

        <!-- 4. Information technology and software engineering -->
        <div class="col-md-6 col-lg-3">
          <div class="mx-service-card h-100 p-3 mx-card-hover">
            <div class="d-flex align-items-start gap-2 mb-2">
              <div class="mx-service-icon">
                <i class="bi bi-phone"></i>
              </div>
              <div class="mx-service-title-wrap">
                <div>
                  <div class="mx-service-mini-tag">Development</div>
                  <h3 class="h6 mt-1 mb-0">Information technology and software engineering</h3>
                </div>
              </div>
            </div>
            <p class="small text-muted mb-3">
              Developing reliable web and mobile applications, secure databases,
              and well structured health information systems.
            </p>
            <div class="mx-service-metric">
              <div>
                <div class="mx-service-label text-muted">Release cadence</div>
                <div class="small fw-semibold">Regular improvements</div>
              </div>
              <div class="mx-service-spark">
                <svg viewBox="0 0 100 24" preserveAspectRatio="none" aria-hidden="true">
                  <path class="spark-grid" d="M0 18 H100" />
                  <rect class="spark-bar" x="4"  y="14" width="6" height="4" />
                  <rect class="spark-bar" x="22" y="13" width="6" height="5" />
                  <rect class="spark-bar" x="40" y="11" width="6" height="7" />
                  <rect class="spark-bar" x="58" y="9"  width="6" height="9" />
                  <rect class="spark-bar" x="76" y="7"  width="6" height="11" />
                </svg>
              </div>
            </div>
          </div>
        </div>

        <!-- 5. Global public health monitoring and evaluation -->
        <div class="col-md-6 col-lg-3">
          <div class="mx-service-card h-100 p-3 mx-card-hover">
            <div class="d-flex align-items-start gap-2 mb-2">
              <div class="mx-service-icon">
                <i class="bi bi-clipboard-data"></i>
              </div>
              <div class="mx-service-title-wrap">
                <div>
                  <div class="mx-service-mini-tag">M and E</div>
                  <h3 class="h6 mt-1 mb-0">Global public health monitoring and evaluation</h3>
                </div>
              </div>
            </div>
            <p class="small text-muted mb-3">
              Strengthening health programmes through monitoring frameworks, evaluations,
              indicators, and data quality improvement.
            </p>
            <div class="mx-service-metric">
              <div>
                <div class="mx-service-label text-muted">Programme coverage</div>
                <div class="small fw-semibold">Improved reporting</div>
              </div>
              <div class="mx-service-spark">
                <svg viewBox="0 0 100 24" preserveAspectRatio="none" aria-hidden="true">
                  <path class="spark-grid" d="M0 18 H100" />
                  <path class="spark-area"
                        d="M0 18 L15 16 L30 14 L45 13 L60 11 L75 9 L90 8 L100 7 L100 24 L0 24 Z" />
                  <path class="spark-line spark-line-3"
                        d="M0 18 L15 16 L30 14 L45 13 L60 11 L75 9 L90 8 L100 7" />
                </svg>
              </div>
            </div>
          </div>
        </div>

        <!-- 6. Digital health consulting and innovation -->
        <div class="col-md-6 col-lg-3">
          <div class="mx-service-card h-100 p-3 mx-card-hover">
            <div class="d-flex align-items-start gap-2 mb-2">
              <div class="mx-service-icon">
                <i class="bi bi-lightbulb"></i>
              </div>
              <div class="mx-service-title-wrap">
                <div>
                  <div class="mx-service-mini-tag">Advisory</div>
                  <h3 class="h6 mt-1 mb-0">Digital health consulting and innovation</h3>
                </div>
              </div>
            </div>
            <p class="small text-muted mb-3">
              Providing strategic guidance for digital transformation, technology adoption,
              and innovative solutions in health systems.
            </p>
            <div class="mx-service-metric">
              <div>
                <div class="mx-service-label text-muted">Engagement</div>
                <div class="small fw-semibold">High partner input</div>
              </div>
              <div class="mx-service-spark">
                <svg viewBox="0 0 100 24" preserveAspectRatio="none" aria-hidden="true">
                  <path class="spark-grid" d="M0 14 H100" />
                  <path class="spark-line spark-line-4"
                        d="M0 14
                           C10 8, 20 18, 30 14
                           C40 8, 50 18, 60 14
                           C70 8, 80 18, 90 14
                           C95 11, 100 15, 100 15" />
                </svg>
              </div>
            </div>
          </div>
        </div>

        <!-- 7. Data visualization and decision support -->
        <div class="col-md-6 col-lg-3">
          <div class="mx-service-card h-100 p-3 mx-card-hover">
            <div class="d-flex align-items-start gap-2 mb-2">
              <div class="mx-service-icon">
                <i class="bi bi-bar-chart"></i>
              </div>
              <div class="mx-service-title-wrap">
                <div>
                  <div class="mx-service-mini-tag">Dashboards</div>
                  <h3 class="h6 mt-1 mb-0">Data visualization and decision support</h3>
                </div>
              </div>
            </div>
            <p class="small text-muted mb-3">
              Transforming complex datasets into clear, interactive dashboards and visual tools
              that guide real time decisions.
            </p>
            <div class="mx-service-metric">
              <div>
                <div class="mx-service-label text-muted">View usage</div>
                <div class="small fw-semibold">Active dashboards</div>
              </div>
              <div class="mx-service-spark">
                <svg viewBox="0 0 100 24" preserveAspectRatio="none" aria-hidden="true">
                  <path class="spark-grid" d="M0 18 H100" />
                  <rect class="spark-bar" x="6"  y="14" width="6" height="4" />
                  <rect class="spark-bar" x="24" y="13" width="6" height="5" />
                  <rect class="spark-bar" x="42" y="10" width="6" height="8" />
                  <rect class="spark-bar" x="60" y="8"  width="6" height="10" />
                  <rect class="spark-bar" x="78" y="9"  width="6" height="9" />
                </svg>
              </div>
            </div>
          </div>
        </div>

        <!-- 8. Project management and programme delivery -->
        <div class="col-md-6 col-lg-3">
          <div class="mx-service-card h-100 p-3 mx-card-hover">
            <div class="d-flex align-items-start gap-2 mb-2">
              <div class="mx-service-icon">
                <i class="bi bi-briefcase"></i>
              </div>
              <div class="mx-service-title-wrap">
                <div>
                  <div class="mx-service-mini-tag">Delivery</div>
                  <h3 class="h6 mt-1 mb-0">Project management and programme delivery</h3>
                </div>
              </div>
            </div>
            <p class="small text-muted mb-3">
              Leading and coordinating health and technology projects from planning to implementation,
              ensuring timely and successful delivery.
            </p>
            <div class="mx-service-metric">
              <div>
                <div class="mx-service-label text-muted">Delivery rate</div>
                <div class="small fw-semibold">Strong completion record</div>
              </div>
            <div class="mx-service-spark">
              <svg viewBox="0 0 100 24" preserveAspectRatio="none" aria-hidden="true">
                <path class="spark-grid" d="M0 18 H100" />
                <polyline class="spark-line spark-line-5"
                          points="0,18 18,16 36,15 54,13 72,12 88,11 100,10" />
              </svg>
            </div>
            </div>
          </div>
        </div>

      </div><!-- /.row -->
    </div><!-- /.mx-service-grid-outer -->

  </div>
</section>

<!-- Program Footprint / Metrics Band -->
<section class="section-metrics text-center text-md-start">
  <div class="container">
    <div class="d-flex flex-column flex-md-row align-items-md-center justify-content-md-between mb-3">
      <div>
        <h2 class="h4 mb-1 section-title">Programme footprint in numbers</h2>
        <p class="small text-muted mb-0">
          Illustrative metrics showing how MaColX supports national programmes and partners.
        </p>
      </div>
      <div class="d-flex align-items-center gap-2 mt-2 mt-md-0">
        <span class="metrics-dot-live"></span>
        <span class="small text-muted">Live implementations across several programmes</span>
      </div>
    </div>

    <div class="row gx-3 gy-3 mx-metric-grid">
      <div class="col-md-4">
        <div class="mx-metric-card h-100">
          <div class="mx-metric-label text-uppercase">Digital systems supported</div>
          <div class="mx-metric-number-wrap">
            <div class="mx-metric-number">15+</div>
          </div>
          <div class="mx-metric-caption">
            National or sub national information systems, records platforms, and logistics tools connected through common standards.
          </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="mx-metric-card h-100">
          <div class="mx-metric-label text-uppercase">Facilities digitised</div>
          <div class="mx-metric-number-wrap">
            <div class="mx-metric-number">500+</div>
          </div>
          <div class="mx-metric-caption">
            Frontline facilities submitting routine data into DHIS2 and aligned national data warehouses.
          </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="mx-metric-card h-100">
          <div class="mx-metric-label text-uppercase">Professionals trained</div>
          <div class="mx-metric-number-wrap">
            <div class="mx-metric-number">200+</div>
          </div>
          <div class="mx-metric-caption">
            Information technology, data, and monitoring staff trained on secure data use, analytics, and governance practices.
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Process Pipeline -->
<section class="section section-pipeline text-center">
  <div class="container">
    <h2 class="h4 mb-3 section-title">How we deliver</h2>
    <p class="small text-muted mb-4">
      We follow a clear implementation lifecycle, from country needs to sustainable scale,
      aligned with guidance from global health partners.
    </p>
    <div class="pipeline-wrapper d-flex flex-wrap justify-content-center align-items-center gap-3">
      <div class="pipeline-step"><i class="bi bi-pencil-square"></i> Design</div>
      <div class="pipeline-arrow"></div>
      <div class="pipeline-step"><i class="bi bi-code-slash"></i> Develop</div>
      <div class="pipeline-arrow"></div>
      <div class="pipeline-step"><i class="bi bi-cloud-check"></i> Deploy</div>
      <div class="pipeline-arrow"></div>
      <div class="pipeline-step"><i class="bi bi-person-lines-fill"></i> Support</div>
    </div>
  </div>
</section>

<!-- Governance & Compliance -->
<section class="section section-governance">
  <div class="container">
    <div class="row justify-content-center mb-3">
      <div class="col-lg-8 text-center">
        <h2 class="h4 mb-2 section-title">Governance, standards, and compliance</h2>
        <p class="small text-muted mb-0">
          Each implementation follows national strategies, global guidance, and good practice
          for digital health and data protection.
        </p>
      </div>
    </div>

    <div class="row justify-content-center">
      <div class="col-lg-9">
        <div class="mx-glass p-3 p-md-4 rounded-4 shadow-sm">
          <div class="accordion" id="governanceAccordion">
            
            <div class="accordion-item">
              <h2 class="accordion-header" id="heading-standards">
                <button class="accordion-button" type="button"
                        data-bs-toggle="collapse" data-bs-target="#collapse-standards"
                        aria-expanded="true" aria-controls="collapse-standards">
                  Standards and interoperability
                </button>
              </h2>
              <div id="collapse-standards" class="accordion-collapse collapse show"
                   aria-labelledby="heading-standards" data-bs-parent="#governanceAccordion">
                <div class="accordion-body small text-muted">
                  Solutions are designed around guidance from the World Health Organization,
                  HL7 FHIR concepts, ICD 10 or ICD 11 coding, and national enterprise architectures,
                  supporting connections with DHIS2, clinical records, registries, and logistics platforms.
                </div>
              </div>
            </div>

            <div class="accordion-item">
              <h2 class="accordion-header" id="heading-privacy">
                <button class="accordion-button collapsed" type="button"
                        data-bs-toggle="collapse" data-bs-target="#collapse-privacy"
                        aria-expanded="false" aria-controls="collapse-privacy">
                  Privacy, security, and data protection
                </button>
              </h2>
              <div id="collapse-privacy" class="accordion-collapse collapse"
                   aria-labelledby="heading-privacy" data-bs-parent="#governanceAccordion">
                <div class="accordion-body small text-muted">
                  Architectures respect national data protection laws and global good practice,
                  including role based access controls, audit logs, encryption in transit and at rest,
                  and security by design principles similar to controls in ISO 27001 where relevant.
                </div>
              </div>
            </div>

            <div class="accordion-item">
              <h2 class="accordion-header" id="heading-governance">
                <button class="accordion-button collapsed" type="button"
                        data-bs-toggle="collapse" data-bs-target="#collapse-governance"
                        aria-expanded="false" aria-controls="collapse-governance">
                  Governance, ownership, and capacity
                </button>
              </h2>
              <div id="collapse-governance" class="accordion-collapse collapse"
                   aria-labelledby="heading-governance" data-bs-parent="#governanceAccordion">
                <div class="accordion-body small text-muted">
                  Work is channelled through country leadership, steering committees, and technical working groups
                  to define governance models, data sharing agreements, and maintenance plans.
                  This is backed by ongoing mentoring for government information technology, data,
                  and monitoring teams so that ownership stays within the health system.
                </div>
              </div>
            </div>

          </div> <!-- /accordion -->
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Standards Compliance Highlight -->
<section class="section section-standards text-center">
  <div class="container">
    <div class="mx-glass p-4 p-md-5 rounded-4 shadow-sm">
      <p class="small text-muted mb-0">
        All MaColX solutions are engineered to be based on standards, secure, and centred on people,
        supporting countries to scale digital health safely in line with global guidance
        and national digital health strategies.
      </p>
    </div>
  </div>
</section>

<!-- Tools & Technologies -->
<section class="section section-alt section-tools">
  <div class="container">
    <div class="row align-items-center g-4">
      <div class="col-lg-5">
        <h2 class="h5 mb-2 section-title">Tools and technologies we work with</h2>
        <p class="small text-muted mb-0">
          We combine open source platforms, cloud services, and analytics tools that are widely used
          in global health implementations.
        </p>
      </div>
      <div class="col-lg-7">
        <div class="d-flex flex-wrap gap-2">
          <span class="badge rounded-pill bg-light text-dark border">DHIS2</span>
          <span class="badge rounded-pill bg-light text-dark border">OpenMRS</span>
          <span class="badge rounded-pill bg-light text-dark border">OpenHIM</span>
          <span class="badge rounded-pill bg-light text-dark border">HL7 FHIR</span>
          <span class="badge rounded-pill bg-light text-dark border">ICD 10 and ICD 11</span>
          <span class="badge rounded-pill bg-light text-dark border">Python and R</span>
          <span class="badge rounded-pill bg-light text-dark border">Power BI</span>
          <span class="badge rounded-pill bg-light text-dark border">PostgreSQL</span>
          <span class="badge rounded-pill bg-light text-dark border">Linux and Docker</span>
          <span class="badge rounded-pill bg-light text-dark border">Azure and AWS</span>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- CTA -->
<section class="section text-center">
  <div class="container">
    <div class="cta-box p-4 p-md-5 rounded-4 shadow-sm mx-glass">
      <h2 class="h4 mb-2 section-title">Let us build better digital health systems together</h2>
      <p class="small text-muted mb-4">
        Start a conversation on how we can strengthen your programmes with secure,
        data driven digital health solutions.
      </p>
      <a href="<?= $base ?>/contact.php" class="btn btn-mx btn-lg">Start a project</a>
    </div>
  </div>
</section>

<?php include __DIR__ . "/includes/footer.php"; ?>
